/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: max_join_size.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "max_join_size", QObject::tr(
"Statements will not be performed if they are likely to need to examine more "
"than this number of rows, row combinations or do more disk seeks. Can prevent "
"poorly-formatted queries from taking server resources. Changing this value to "
"anything other the default will reset <b>sql_big_selects</b> to <b>0</b>. If "
"<b>sql_big_selects</b> is set again, <b>max_join_size</b> will be ignored. "
"This limit is also ignored if the query result is sitting in the query cache"
));

u.u->setCommandLine(QStringList()<<"--max_join_size");
u.u->setConfigLine("max_join_size");
u.u->setRange(1, 18446744073709551615ULL);
u.u->setValue(18446744073709551615ULL);

/* EOF */
