/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: max_user_connections.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_integer(map, "max_user_connections", QObject::tr(
"Maximum simultaneous connections permitted for a user account. If set to "
"<b>0</b>, the default, there is no per-user limit. The session value is "
"<b>read-only</b> and takes the global value unless there's a nonzero "
"<b>MAX_USER_CONNECTIONS</b> value for the user. Previously having a minimum "
"value of <b>0</b>, from MariaDB 5.3, <b>max_user_connections</b> can be set "
"to <b>-1</b> to stop users from connecting to the server. The global "
"<b>max_user_connections</b> variable does not affect users with the "
"<b>SUPER</b> privilege"
));

u.i->setCommandLine(QStringList()<<"--max_user_connections");
u.i->setConfigLine("max_user_connections");
u.i->setRange(-1, 4294967295LL);
u.i->setValue(0);

/* EOF */
