/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: myisam_stats_method.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "myisam_stats_method", QObject::tr(
"Determines how <b>NULL</b>s are treated for <b>MyISAM</b> index statistics "
"purposes. If set to <b>nulls_equal</b>, the default, all <b>NULL</b> index "
"values are treated as a single group. This is usually fine, but if you have "
"large numbers of <b>NULL</b>s the average group size is slanted higher, and "
"the optimizer may miss using the index for ref accesses when it would be "
"useful. If set to <b>nulls_unequal</b>, the opposite approach is taken, with "
"each <b>NULL</b> forming its own group of one. Conversely, the average group "
"size is slanted lower, and the optimizer may use the index for ref accesses "
"when not suitable. Setting to <b>nulls_ignored</b> ignores <b>NULL</b>s "
"altogether from index group calculations"
));

u.e->setCommandLine(QStringList()<<"--myisam_stats_method");
u.e->setConfigLine("myisam_stats_method");
u.e->setEnumeration(EnumVector()
	<<EnumItem("nulls_equal", QObject::tr("nulls_equal"))
	<<EnumItem("nulls_unequal", QObject::tr("nulls_unequal"))
	<<EnumItem("nulls_ignored", QObject::tr("nulls_ignored"))
);
u.e->setValue("nulls_equal");

/* EOF */
