/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: optimizer_use_condition_selectivity.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "optimizer_use_condition_selectivity", QObject::tr(
"Controls selectivity of which conditions the optimizer takes into account to "
"calculate cardinality of a partial join when it searches for the best "
"execution plan Meaning:"
"<ul>"
"<li><b>1</b> - use selectivity of index backed range conditions to calculate "
"the cardinality of a partial join if the last joined table is accessed by "
"full table scan or an index scan"
"<li><b>2</b> - use selectivity of index backed range conditions to calculate "
"the cardinality of a partial join in any case"
"<li><b>3</b> - additionally always use selectivity of range conditions that "
"are not backed by any index to calculate the cardinality of a partial join"
"<li><b>4</b> - use histograms to calculate selectivity of range conditions "
"that are not backed by any index to calculate the cardinality of a partial "
"join"
"<li><b>5</b> - additionally use selectivity of certain non-range predicates "
"calculated on record samples"
"</ul>"
));

u.u->setCommandLine(QStringList()<<"--optimizer_use_condition_selectivity");
u.u->setConfigLine("optimizer_use_condition_selectivity");
u.u->setRange(1, 5);
u.u->setValue(1);

/* EOF */
