/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: query_cache_type.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "query_cache_type", QObject::tr(
"If set to <b>0</b>, the query cache is disabled (although a buffer of "
"<b>query_cache_size</b> bytes is still allocated). If set to <b>1</b> all "
"<b>SELECT</b> queries will be cached unless <b>SQL_NO_CACHE</b> is specified. "
"If set to <b>2</b>, no only queries with <b>SQL CACHE</b> will be cached. "
"Note that if the server is started with the query cache disabled, it cannot "
"be enabled at runtime"
));

u.e->setCommandLine(QStringList()<<"--query_cache_type");
u.e->setConfigLine("query_cache_type");
u.e->setEnumeration(EnumVector()
	<<EnumItem("0", QObject::tr("Off"))
	<<EnumItem("1", QObject::tr("On"))
	<<EnumItem("2", QObject::tr("Demand"))
);
u.e->setValue("1");

/* EOF */
