/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: read_buffer_size.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "read_buffer_size", QObject::tr(
"Each thread performing a sequential scan (for <b>MyISAM</b>, <b>Aria</b> and "
"<b>MERGE</b> tables) allocates a buffer of this size in bytes for each table "
"scanned. Increase if you perform many sequential scans. If not in a multiple "
"of <b>4KB</b>, will be rounded down to the nearest multiple. Also used in "
"<b>ORDER BY</b>'s for caching indexes in a temporary file (not temporary "
"table), for caching results of nested queries, for bulk inserts into "
"partitions, and to determine the memory block size of <b>MEMORY</b> tables"
));

u.u->setCommandLine(QStringList()<<"--read_buffer_size");
u.u->setConfigLine("read_buffer_size");
u.u->setRange(8192, 2147479552ULL);
u.u->setValue(131072);

/* EOF */
