/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: read_only.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_boolean(map, "read_only", QObject::tr(
"When set to <b>1</b> (<b>0</b> is default), no updates are permitted except "
"from users with the <b>SUPER</b> privilege or slave servers updating from a "
"master. The <b>read_only</b> variable is useful for slave servers to ensure "
"no updates are accidentally made outside of what are performed on the master. "
"Inserting rows to log tables, updates to temporary tables and <b>OPTIMIZE</b> "
"or <b>ANALYZE TABLE</b> statements are excluded from this limitation. From "
"<b>MariaDB/MySQL 5.5</b>, if <b>read_only</b> is set to <b>1</b>, <b>SET "
"PASSWORD</b> is limited only to users with the <b>SUPER</b> privilege. "
"Changing this to <b>1</b> will fail if you have table locks or transactions "
"pending, while it will wait until other locks are released or transactions "
"are completed"
));

u.b->setCommandLine(QStringList()<<"--read-only");
u.b->setConfigLine("read_only");
u.b->setValue(FALSE);

/* EOF */
