/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: slave_exec_mode.hpp,v 1.1 2013/10/08 14:38:37 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_enum(map, "slave_exec_mode", QObject::tr(
"Determines the mode used for replication error checking and conflict "
"resolution. <b>STRICT</b> mode is the default, and catches all all errors and "
"conflicts. <b>IDEMPOTENT</b> mode suppresses duplicate key or no key errors, "
"which can be useful in certain replication scenarios, such as when there are "
"multiple masters, or circular replication. <b>MySQL Cluster</b> ignores this "
"setting, always treating it as <b>IDEMPOTENT</b>"
));

u.e->setCommandLine(QStringList()<<"--slave_exec_mode=#");
u.e->setConfigLine("slave_exec_mode");
u.e->setEnumeration(EnumVector()
	<<EnumItem("IDEMPOTENT", QObject::tr("IDEMPOTENT (NDB)"))
	<<EnumItem("STRICT", QObject::tr("STRICT (All)"))
);
u.e->setValue("STRICT");

/* EOF */
