/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sync_binlog.hpp,v 1.1 2013/10/08 14:38:37 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "sync_binlog", QObject::tr(
"MariaDB will synchronize its binary log file to disk after this many events. "
"The default is <b>0</b>, in which case the operating system handles flushing "
"the file to disk. <b>1</b> is the safest, but slowest, choice, since the file "
"is flushed after each write. If autocommit is enabled, there is one write per "
"statement, otherwise there's one write per transaction. If the disk has cache "
"backed by battery, synchronization will be fast and a more conservative "
"number can be chosen"
));

u.u->setCommandLine(QStringList()<<"--sync_binlog=#");
u.u->setConfigLine("sync_binlog");
u.u->setRange(0, 4294967295ULL);
u.u->setValue(0);

/* EOF */
