/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: thread_cache_size.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "thread_cache_size", QObject::tr(
"Number of threads server caches for re-use. If this limit hasn't been "
"reached, when a client disconnects, its threads are put into the cache, and "
"re-used where possible. Normally this setting has little effect, as the other "
"aspects of the thread implementation are more important, but increasing it "
"can help servers with high volumes of connections per second so that most can "
"use a cached, rather than a new, thread. The cache miss rate can be "
"calculated as the server status variables <b>threads_created/connections</b>. "
"If the <b>thread pool</b> is active, <b>thread_cache_size</b> is ignored"
));

u.u->setCommandLine(QStringList()<<"--thread_cache_size");
u.u->setConfigLine("thread_cache_size");
u.u->setRange(0, 16384);
u.u->setValue(128);

/* EOF */
