/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: tmp_table_size.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "tmp_table_size", QObject::tr(
"The largest size for temporary tables in memory (not <b>MEMORY</b> tables) "
"although if <b>max_heap_table_size</b> is smaller the lower limit will apply. "
"If a table exceeds the limit, MariaDB converts it to a MyISAM or Aria table. "
"You can see if it's necessary to increase by comparing the status variables "
"<b>Created_tmp_disk_tables</b> and <b>Created_tmp_tables</b> to see how many "
"temporary tables out of the total created needed to be converted to disk. "
"Often complex <b>GROUP BY</b> queries are responsible for exceeding the limit"
));

u.u->setCommandLine(QStringList()<<"--tmp_table_size");
u.u->setConfigLine("tmp_table_size");
u.u->setRange(1024, 4294967295ULL);
u.u->setValue(16777216ULL);

/* EOF */
