/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: transaction_prealloc_size.hpp,v 1.1 2013/10/07 17:00:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

u.a = add_unsigned(map, "transaction_prealloc_size", QObject::tr(
"Initial size of a memory pool available to each transaction for various "
"memory allocations. If the memory pool is not large enough for an allocation, "
"it is increased by <b>transaction_alloc_block_size</b> bytes, and truncated "
"back to <b>transaction_prealloc_size</b> bytes when the transaction is "
"completed. If set large enough to contain all statements in a transaction, "
"extra <b>malloc()</b> calls are avoided"
));

u.u->setCommandLine(QStringList()<<"--transaction_prealloc_size");
u.u->setConfigLine("transaction_prealloc_size");
u.u->setRange(1024, 4294966272ULL);
u.u->setValue(4096);

/* EOF */
