/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: cisco.h,v 0.1 2009/05/20 14:18:23 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#ifndef	__CISCO_H__
#define	__CISCO_H__

#include "gui.h"
#include "cisco_int.h"
#include "cisco_bgp.h"

/*   */
typedef	QMap<QString, int>	IntMap;

/*   */
typedef	QPtrList<CiscoInt>	IntList;

class Cisco:public QScrollView
{
	Q_OBJECT
public:
	enum Command {
		NOOP,
		SH_INT,
		SH_BGP
	};

	Cisco(QWidget *parent = NULL);
	~Cisco();

	void	setCisco(cisco_t &);
	void	saveSettings(QSettings *, int, const QString&);
	void	loadSettings(const QString&);
	void	readCisco(QString&);
	void	readImage(QByteArray&, const QStringList&);

	const QString&	host()const{return (hst);}
	const QString&	user()const{return (usr);}
	const QString&	password()const{return (pass);}

private:
	bool		logged, sh_bgp;
	Command		cmd;
	IntMap		ifmap;
	IntList		iflist;
	CiscoBGP	*bgp;
	QString		hst, tail;
	QString		usr, pass;
	QStringList	input, list;
	QSocket		*sock;
	QColor		normal;
	QTimer		*timer, *reconnect;
	QPopupMenu	*menu;

	void	quitCommand();
	void	sendCommand(const QString&);
	void	readAll();
	void	addChunk(char *, size_t);
	void	parseData();
	void	parseInterfaces(QStringList&);
	void	parseBGP(QStringList&);
	void	resizeChildren();

	bool		isPrompt();
	bool		isMore();
	bool		isLogin();
	bool		isPassword();
	bool		isCommand();
	bool		hasTail(const char *);
	Command		nextCommand(Command);
	CiscoInt	*findIface(const QString&);

protected:
	void	resizeEvent(QResizeEvent *);
	void	mousePressEvent(QMouseEvent *);

private slots:
	void	readData();
	void	ciscoCommand();
	void	ciscoDown();
	void	ciscoReconnect();
	void	ciscoError(int);
	void	ciscoEnable();
	void	bgpUp();
	void	bgpDown();
	void	chInterface(int);

signals:
	void	statusDown();
	void	statusUp();
	void	showMe(QWidget *);
};

#endif	/* __CISCO_H__ */

/* EOF */
