/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: cisco_bgp.h,v 0.1 2009/05/21 19:26:10 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#ifndef	__CISCO_BGP_H__
#define	__CISCO_BGP_H__

#include "gui.h"

class MemLine;

class CiscoBGP:public QGroupBox
{
	Q_OBJECT
public:
	CiscoBGP(QWidget *parent = NULL);
	~CiscoBGP();

	void	parseLine(QString&);
	void	readData(QString&, const QString&);
	void	readImage(QByteArray&, const QString&);

private:
	MemLine		*net, *path;
	QListView	*bgp;
	char		**old;
	QColor		normal;

	void	addBGP(QString&);
	void	testStatus(char **);
	void	resizeBGP();

protected:
	void	resizeEvent(QResizeEvent *);

signals:
	void	bgpDown();
	void	bgpUp();
};

//-----------------------------------------------------------------------------

class MemLine:public QWidget
{
	Q_OBJECT
public:
	MemLine(const QString &, QWidget *parent = NULL);
	~MemLine();

	void	setData(const QString&, const QString&);

	QString	text()const;

private:
	QLabel		*l_desc, *l_bm, *l_using;
	QLCDNumber	*bm, *ent;

protected:
	void	resizeEvent(QResizeEvent *);
};

#endif	/* __CISCO_BGP_H__ */

/* EOF */
