/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: cisco_dialog.cpp,v 0.1 2009/05/22 15:32:17 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#include "cisco_dialog.h"

CiscoDialog::CiscoDialog(QWidget *parent)
	:QDialog(parent)
{
	int	wdt, hgt;

	/*   */
	l_host = new QLabel(tr("Cisco hostname (or IP)"), this);
	l_host->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	host = new QLineEdit(this);
	host->setMaxLength(128);

	/*    */
	l_login = new QLabel(tr("Login (may be empty)"), this);
	l_login->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	login = new QLineEdit(this);
	login->setMaxLength(32);

	/*    */
	l_password = new QLabel(tr("Password"), this);
	l_password->setAlignment(Qt::AlignLeft | Qt::AlignVCenter);
	password = new QLineEdit(this);
	password->setMaxLength(32);

	/*   BGP- */
	bgp = new QCheckBox(tr("Show the BGP sessions"), this);
	bgp->setChecked(FALSE);

	/*    */
	ok = new QPushButton(tr("Add"), this);
	ok->setFocusPolicy(QWidget::NoFocus);
	cancel = new QPushButton(tr("Cancel"), this);
	cancel->setFocusPolicy(QWidget::NoFocus);

	connect(host, SIGNAL(textChanged(const QString&)),
		this, SLOT(testData(const QString&)));
	connect(password, SIGNAL(textChanged(const QString&)),
		this, SLOT(testData(const QString&)));
	connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));

	hgt = fontMetrics().lineSpacing() * 8;
	wdt = hgt * 16 / 9;
	resize(wdt, hgt);
	setMinimumSize(size());
	setMaximumSize(size());

	testData(QString::null);
}

CiscoDialog::~CiscoDialog()
{

	delete cancel;
	delete ok;
	delete bgp;
	delete password;
	delete l_password;
	delete login;
	delete l_login;
	delete host;
	delete l_host;
}


void
CiscoDialog::resizeEvent(QResizeEvent *e)
{
	int	wdt = e->size().width(),
		hgt = e->size().height(),
		fh = fontMetrics().lineSpacing() + EXTRA,
		bh = fh * 7 / 5,
		y = 0;

	QDialog::resizeEvent(e);

	/*   */
	l_host->setGeometry(0, y, wdt / 2, fh);
	host->move(l_host->x() + l_host->width(), y);
	host->resize(wdt - host->x(), fh);
	y += fh;

	/*    */
	l_login->setGeometry(0, y, wdt / 2, fh);
	login->move(l_login->x() + l_login->width(), y);
	login->resize(wdt - login->x(), fh);
	y += fh;

	/*    */
	l_password->setGeometry(0, y, wdt / 2, fh);
	password->move(l_password->x() + l_password->width(), y);
	password->resize(wdt - password->x(), fh);
	y += fh;

	/*   BGP- */
	bgp->setGeometry(0, y, wdt, fh);
	y += fh;

	/*    */
	cancel->resize(wdt / 4, bh);
	ok->resize(cancel->size());
	cancel->move(wdt - cancel->width() - EXTRA,
		hgt - cancel->height() - EXTRA);
	ok->move(cancel->x() - EXTRA - ok->width(), cancel->y());
}


/*       */
void
CiscoDialog::testData(const QString&)
{
	bool	ena = !host->text().isEmpty();

	if (ena)
		ena = !password->text().isEmpty();

	ok->setEnabled(ena);
}


/*          */
void
CiscoDialog::getData(cisco_t &cisco)
{

	cisco.host = host->text();
	cisco.login = login->text();
	cisco.password = password->text();
	cisco.bgp = bgp->isChecked();
}


/* EOF */
