/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: cisco_int.h,v 0.1 2009/05/20 16:58:27 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#ifndef	__CISCO_INTERFACE_H__
#define	__CISCO_INTERFACE_H__

#include "gui.h"

/*    */
typedef	struct {
	uint64_t	rate;		/* / */
	uint32_t	speed;		/* / */
	uint64_t	pkts, bytes;	/*     */
	uint64_t	errs;		/*   */
	QTime		act;		/*   */
	bool		ena;		/* TRUE,    */
} iface_info_t;

typedef	struct {
	QTime	time;
	int	rate;
} point_t;

typedef	QPtrList<point_t>	RateList;

class IntInfo;
class IntDrawer;

class CiscoInt:public QGroupBox
{
	Q_OBJECT
public:
	enum InterfaceStatus {
		INT_UP,
		INT_DOWN
	};
	enum ProtocolStatus {
		PROTO_UP,
		PROTO_DOWN
	};

	CiscoInt(QWidget *parent = NULL);
	~CiscoInt();

	void	setStatus(InterfaceStatus);
	void	setStatus(ProtocolStatus);
	void	parseLine(QString&);
	void	setMenuId(int id){menuid = id;}
	void	showInterface(bool);
	void	readData(QString&, const QString&);
	void	readImage(QByteArray&, const QChar&);

	static void	parseInterface(QString&, QString&, InterfaceStatus&,
				ProtocolStatus&);

	int	menuId()const{return (menuid);}

private:
	int		menuid;	/*    */
	bool		flag;
	InterfaceStatus	st_int;	/*   */
	ProtocolStatus	st_pro;	/*   */
	QString		desc;	/*   */
	QString		addr;	/* IP-  */
	iface_info_t	input;	/*    */
	iface_info_t	output;	/*    */
	QLabel		*l_desc;
	QLabel		*l_st_int, *l_st_pro;
	IntInfo		*i_info;
	IntInfo		*o_info;

	void	setRate(iface_info_t&, QString&);
	void	setTraffic(iface_info_t&, QString&);
	void	setTime(const QString&, const QString&);
	void	clearInfo(iface_info_t&);

	QTime	strTime(const QStringList&)const;

protected:
	void	resizeEvent(QResizeEvent *);

public slots:
	void	showInfo();

signals:
	void	needResize();
};

//-----------------------------------------------------------------------------

class IntInfo:public QGroupBox
{
	Q_OBJECT;
public:
	IntInfo(const QString&, QWidget *parent = NULL);
	~IntInfo();

	void	showInfo(const iface_info_t&);
	void	readImage(QByteArray&);

	QString	text(const QString&, const QString&);

private:
	QString		idle_str, rate_str, speed_str, pkts_str;
	QString		traf_str, errs_str;
	QLabel		*l_rate, *l_speed, *l_pkts, *l_traf;
	QLabel		*l_errs, *l_idle;
	QLCDNumber	*rate, *speed, *pkts, *traf, *errs, *idle;
	IntDrawer	*drawer;

	void	moveLine(int&, int, int, int, QLabel *, QLCDNumber *);

protected:
	void	resizeEvent(QResizeEvent *);
};

//-----------------------------------------------------------------------------

class IntDrawer:public QWidget
{
	Q_OBJECT;
public:
	IntDrawer(QWidget *parent = NULL);
	~IntDrawer();

	void	insertRate(int);

	const QByteArray&	image()const{return (img);}

private:
	int		min_rate, max_rate;
	int		old_x, old_y;
	QString		kbps;
	QPixmap		*xpm;
	QByteArray	img;
	RateList	*list;
	QColor		fillColor, gridColor, color, colorText;

	void	redraw();
	void	padList();
	void	makeArray(QPointArray&);

	int	countRate(int);

protected:
	void	resizeEvent(QResizeEvent *);
	void	paintEvent(QPaintEvent *);
	void	mouseMoveEvent(QMouseEvent *);
};

#endif	/* __CISCO_INTERFACE_H__ */

/* EOF */
