/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: client_http.cpp,v 0.1 2009/05/25 14:32:05 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9)
 *
 * Hacked by:
 */

#include "client_http.h"

static const char
	eol[2] = {'\r', '\n'},
	icon[] = {
0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x20, 0x20, 0x02, 0x00, 0x01, 0x00,
0x01, 0x00, 0x30, 0x01, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x28, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0x00,
0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x01, 0x9c, 0x08, 0x00, 0x02, 0x68, 0x24, 0x00,
0x05, 0xb0, 0x30, 0xc7, 0xf2, 0xc0, 0x39, 0x1f, 0xff, 0x00, 0x17, 0x27,
0xff, 0x80, 0x0e, 0xfb, 0xfc, 0x00, 0x0f, 0xff, 0xff, 0xc0, 0x07, 0xfb,
0xbf, 0xfc, 0x07, 0xdd, 0xdf, 0xfe, 0x06, 0xee, 0x7e, 0x1e, 0x07, 0x77,
0x9b, 0xfe, 0x05, 0xb9, 0x17, 0xec, 0x02, 0xcc, 0x06, 0xec, 0x03, 0x60,
0x05, 0xec, 0x03, 0x80, 0x05, 0xf8, 0x04, 0x00, 0x01, 0xe0, 0x0e, 0x00,
0x00, 0xe0, 0x10, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00};

ClientHttp::ClientHttp(int fd)
{

	sock = fd;
	st = HTTP_RECV;
	start();
}

ClientHttp::~ClientHttp()
{

	wait();
	shutdown(sock, SHUT_RDWR);
	close(sock);
}


void
ClientHttp::run()
{
	char	buf[4096];
	size_t	size = sizeof(buf) - 1;
	ssize_t	len;
	int	pos;

	buf[size] = '\0';
	for (pos = -1; pos < 0; ) {
		len = recv(sock, buf, size, 0);
		if (len <= 0)
			break;
		if (len < (ssize_t)size)
			buf[len] = '\0';

		mtx.lock();
		data += buf;
		pos = data.find("\r\n\r\n");
		mtx.unlock();
	}

	setState(HTTP_DONE);
}


void
ClientHttp::setState(State s)
{

	mtx.lock();
	st = s;
	mtx.unlock();
}


ClientHttp::State
ClientHttp::state()
{
	ClientHttp::State	ret;

	mtx.lock();
	ret = st;
	mtx.unlock();

	return (ret);
}


/*   */
void
ClientHttp::parseData(Manager *mng)
{
	QHttpRequestHeader	hdr(data);

	hdr.setValue("Connection", "close");
	hdr.setValue("Server", DEFAULT_PROGRAM" v.1.0");

	if (hdr.method().upper() == "GET") {
		/*   */
		sendObject(mng, hdr);
	} else {
		/*   */
		badRequest(hdr);
	}
}


void
ClientHttp::badRequest(QHttpRequestHeader &hdr)
{
	struct sockaddr_in	sin;
	socklen_t		slen = sizeof(sin);

	getsockname(sock, (struct sockaddr *)&sin, &slen);

	QHostAddress	addr(ntohl(sin.sin_addr.s_addr));
	Q_UINT16	port = ntohs(sin.sin_port);
	QDns		dns(addr);

	while (dns.isWorking())
		usleep(100);

	QStringList	lst(dns.hostNames());
	QString	answer("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n"
		"<HTML><HEAD>\n"
		"<TITLE>400 Bad Request</TITLE>\n"
		"</HEAD><BODY>\n"
		"<H1>Bad Request</H1>\n"
		"Your browser sent a request that this server "
			"could not understand.<P>\n"
		"request failed: error reading the headers<P>\n"
		"<HR>\n"
		"<ADDRESS>" + hdr.value("Server") + " Server at " +
		lst[0] + " Port " + QString::number(port) +
		"</ADDRESS>\n"
		"</BODY></HTML>\n"),
		str_hdr("HTTP/%1.%2 400 Bad Request");

	hdr.setValue("Content-Type", "text/html");
	hdr.setValue("Content-Length", QString::number(answer.length()));
	writeLine(str_hdr.arg(hdr.majorVersion()).arg(hdr.minorVersion()));
	sendHeader(hdr);
	writeData(answer);
}


/*    */
void
ClientHttp::sendHeader(QHttpRequestHeader &hdr)
{

	writeLine(hdr, "Server");
	writeLine(hdr, "Connection");
	writeLine(hdr, "Content-Type");
	writeLine(hdr, "Content-Length");
	writeLine(QString::null);
}


void
ClientHttp::writeLine(const QString &str)
{

	writeData(str);
	send(sock, eol, sizeof(eol), 0);
}


void
ClientHttp::writeLine(QHttpRequestHeader &hdr, const QString &key)
{
	QString	str(hdr.value(key));

	if (!str.isEmpty())
		writeLine(key + ": " + str);
}


void
ClientHttp::writeData(const QString &str)
{

	if (!str.isEmpty())
		send(sock, str.ascii(), str.length(), 0);
}


void
ClientHttp::writeData(const QByteArray &img)
{

	if (!img.isNull())
		send(sock, img.data(), img.size(), 0);
}


/*    */
void
ClientHttp::sendObject(Manager *mng, QHttpRequestHeader &hdr)
{
	QString	path(hdr.path());

	if (path == "/") {
		/*     */
		sendMainInfo(mng, hdr);
	} else if (path.find(HTTP_IMG) == 0) {
		/*   */
		path.remove(HTTP_IMG);
		sendImage(mng, path, hdr);
	} else if (path == "/favicon.ico") {
		/*   */
		sendIcon(hdr);
	} else {
		/*    */
		http_404(hdr);
	}
}


/*    */
void
ClientHttp::http_404(QHttpRequestHeader &hdr)
{
	QString	answer("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\n"
		"<html><head>\n"
		"<title>404 Not Found</title>\n"
		"</head><body>\n"
		"<h1>Not Found</h1>\n"
		"<p>The requested URL " + hdr.path() +
		" was not found on this server.</p>\n"
		"</body></html>\n"),
		str_hdr("HTTP/%1.%2 404 Not Found");

	hdr.setValue("Content-Type", "text/html");
	hdr.setValue("Content-Length", QString::number(answer.length()));
	writeLine(str_hdr.arg(hdr.majorVersion()).arg(hdr.minorVersion()));
	sendHeader(hdr);
	writeData(answer);
}


/*      */
void
ClientHttp::sendMainInfo(Manager *mng, QHttpRequestHeader &hdr)
{
	QString	data, info,
		str_hdr("HTTP/%1.%2 200 OK");
	QTextOStream	out(&data);

	mng->readCisco(info);
	out<<"<html>"<<endl
	<<"<head>"<<endl
	<<"<title>Cisco Routers at TSTUNet</title>"<<endl
	<<"<meta HTTP-EQUIV=\"REFRESH\" CONTENT=\"5;URL=/\">"
	<<"</head>"<<endl
	<<"<body bgcolor=\"#FFFFFF\" text=\"#000000\">"<<endl
	<<info<<endl
	<<"<div align=\"right\"><small>Copyright &copy; Denis Kozadaev, "
		"Tambov, 2009</small></div>"<<endl
	<<"</body>"<<endl
	<<"</html>"<<endl;

	hdr.setValue("Content-Type", "text/html");
	hdr.setValue("Content-Length", QString::number(data.length()));
	writeLine(str_hdr.arg(hdr.majorVersion()).arg(hdr.minorVersion()));
	sendHeader(hdr);
	writeData(data);
}


/*    */
void
ClientHttp::sendImage(Manager *mng, const QString &path,
	QHttpRequestHeader &hdr)
{
	QByteArray	img;

	mng->readImage(path, img);
	if (img.isNull())
		http_404(hdr);
	else {
		QString	str_hdr("HTTP/%1.%2 200 OK");

		/*   */
		hdr.setValue("Content-Type", "image/png");
		hdr.setValue("Content-Length", QString::number(img.size()));
		writeLine(str_hdr.arg(hdr.majorVersion())
			.arg(hdr.minorVersion()));
		sendHeader(hdr);
		writeData(img);
	}
}


/*   */
void
ClientHttp::sendIcon(QHttpRequestHeader &hdr)
{
	QString	str_hdr("HTTP/%1.%2 200 OK");

	/*   */
	hdr.setValue("Content-Type", "image/x-icon");
	hdr.setValue("Content-Length", QString::number(sizeof(icon)));
	writeLine(str_hdr.arg(hdr.majorVersion()).arg(hdr.minorVersion()));
	sendHeader(hdr);
	writeData(icon);
}

/* EOF */
