/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: client_http.h,v 0.1 2009/05/25 14:32:05 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9)
 *
 * Hacked by:
 */

#ifndef	__CLIENTHTTP_H__
#define	__CLIENTHTTP_H__

#include "gui.h"
#include "manager.h"

class Manager;

class ClientHttp:public QThread
{
public:
	enum State {
		HTTP_DONE,	/*  */
		HTTP_RECV	/*     */
	};

	ClientHttp(int);
	~ClientHttp();

	void	setState(State);
	void	parseData(Manager *);

	State	state();

private:
	int	sock;
	State	st;
	QMutex	mtx;
	QString	data;

	void	badRequest(QHttpRequestHeader&);
	void	writeLine(const QString&);
	void	writeLine(QHttpRequestHeader&, const QString&);
	void	writeData(const QString&);
	void	sendObject(Manager *, QHttpRequestHeader&);
	void	sendHeader(QHttpRequestHeader&);
	void	http_404(QHttpRequestHeader&);
	void	sendMainInfo(Manager *, QHttpRequestHeader&);
	void	sendImage(Manager *, const QString&, QHttpRequestHeader&);
	void	sendIcon(QHttpRequestHeader&);
	void	writeData(const QByteArray&);

protected:
	void	run();
};

#endif	/* __CLIENTHTTP_H__ */

/* EOF */
