/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: main.cpp,v 0.1 2009/05/20 14:09:15 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9)
 *
 * Hacked by:
 */

#include "gui.h"
#include "mainwindow.h"

QColor	alert(0xFF, 0x9D, 0x9D);	/*     */

static void	loadSettings(QSettings&);
static void	saveSettings(QSettings&);

int
main(int argc, char **argv)
{
	QApplication	*app;
	MainWindow	*mw;
	int		ret;
	QSettings	cfg(QSettings::Native);	/*  */

	cfg.setPath(DEFAULT_DOMAIN, DEFAULT_PROGRAM, QSettings::User);
	loadSettings(cfg);

	app = new QApplication(argc, argv);

	mw = new MainWindow(&cfg, NULL);

	mw->resize(1024, 768);
	mw->show();
	mw->setMinimumSize(mw->size());
	app->setMainWidget(mw);

	ret = app->exec();

	saveSettings(cfg);

	delete mw;
	delete app;

	return (ret);
}


/*    */
void
loadSettings(QSettings &cfg)
{
	QString	fstr;

	fstr = cfg.readEntry(FONT_KEY, QString::null);
	if (!fstr.isEmpty()) {
		QFont	fnt;
		if (fnt.fromString(fstr))
			QApplication::setFont(fnt);
	}
}


/*    */
void
saveSettings(QSettings &cfg)
{

	cfg.writeEntry(FONT_KEY, QApplication::font().toString());
}

/* EOF */
