/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: mainwindow.h,v 0.1 2009/05/20 14:09:34 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#ifndef	__MAIN_WINDOW_H__
#define	__MAIN_WINDOW_H__

#include "gui.h"
#include "manager.h"
#include "player.h"

class MainWindow:public QMainWindow
{
	Q_OBJECT
public:
	MainWindow(QSettings *, QWidget *parent = NULL);
	~MainWindow();

private:
	QSettings	*cfg;
	int		add_id, full_id, grad;
	cisco_t		info;	/*   */
	QPopupMenu	*cisco, *option;
	QTimer		*timer;
	Manager		*manager;
	Player		*player;

	void	loadSettings(QSettings *);
	void	saveSettings();

private slots:
	void	addCisco();
	void	testConnection();
	void	connectionDone();
	void	socketError(int);
	void	fullScreen();
	void	changeFont();
	void	changeDevice();
	void	changeMixer();
	void	mixerControl();
	void	startSound();
	void	stopSound();
	void	chooseFile();
	void	soundVolume();
};

//-----------------------------------------------------------------------------

class Volume:public QGroupBox
{
	Q_OBJECT
public:
	Volume(const QString&, QWidget *parent = NULL);
	~Volume();

	int	volume()const{return (num->intValue());}

private:
	QLCDNumber	*num;
	QDial		*dial;

protected:
	void	resizeEvent(QResizeEvent *);

public slots:
	void	setVolume(int);

signals:
	void	volumeChanged(int);
};

//-----------------------------------------------------------------------------

class VolumeDialog:public QDialog
{
	Q_OBJECT
public:
	VolumeDialog(QWidget *parent = NULL);
	~VolumeDialog();

	void	setVolume(int, int);

	int	normalVolume()const{return (normal->volume());}
	int	alarmVolume()const{return (alarm->volume());}

private:
	Volume		*normal, *alarm;
	QPushButton	*set, *cancel;

protected:
	void	resizeEvent(QResizeEvent *);

private slots:
	void	checkNormal(int);
	void	checkAlarm(int);
};

#endif	/* __MAIN_WINDOW_H__ */

/* EOF */
