/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: manager.cpp,v 0.1 2009/05/20 14:19:21 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#include "manager.h"
#include "client_http.h"

Manager::Manager(QWidget *parent)
	:QTabWidget(parent)
{

	setTabPosition(Top);
	setTabShape(Rounded);
	setFocusPolicy(QWidget::NoFocus);

	http = new HttpServer(this);

}

Manager::~Manager()
{

	delete http;
}


/*      */
void
Manager::insertCisco(cisco_t &info, QSettings *cfg)
{
	Cisco	*ptr;
	QString	name;
	int	pos;

	if ((pos = info.host.find('.')) > 0) {
		name = info.host.left(pos);
		name[0] = name[0].upper();
	} else
		name = info.host;
	ptr = new Cisco(this);
	connect(ptr, SIGNAL(showMe(QWidget *)),
		this, SLOT(showPage(QWidget *)));
	connect(ptr, SIGNAL(statusDown()), SIGNAL(startSound()));
	connect(ptr, SIGNAL(statusUp()), SIGNAL(stopSound()));
	addTab(ptr, name);
	showPage(ptr);
	ptr->setCisco(info);
	if (cfg != NULL)
		ptr->loadSettings(cfg->readEntry(CISCO_KEY"/" + name));
}


/*   */
void
Manager::loadSettings(QSettings *cfg)
{
	int	i;

	for (i = 0; ; i++) {
		QString	name(CISCO + QString::number(i));
		bool	ok;
		QString	entry(cfg->readEntry(CISCO_KEY"/" + name,
				QString::null, &ok));

		if (ok)
			createCisco(entry, cfg);
		else
			break;
	}
	setCurrentPage(0);
}


/*  ,     */
void
Manager::saveSettings(QSettings *cfg)
{
	int	i, cnt = count();

	for (i = 0; i < cnt; i++) {
		Cisco	*ptr = (Cisco *)page(i);

		if (ptr != NULL)
			ptr->saveSettings(cfg, i, tabLabel(ptr));
	}
}


/*
 *  ,    
 * ţ    
 */
void
Manager::createCisco(const QString &str, QSettings *cfg)
{
	QStringList	lst(QStringList::split(':', str, TRUE));

	if (lst.count() >= 4) {
		cisco_t	info;

		/*  */
		info.host = lst[0];
		info.login = lst[1];
		info.password = lst[2];
		info.bgp = (lst[3].toInt() == 1);
		if (!info.host.isEmpty() && !info.password.isEmpty())
			insertCisco(info, cfg);
	}
}


/*          */
void
Manager::readCisco(QString &out)
{
	int	i, cnt = count();

	for (i = 0; i < cnt; i++) {
		Cisco	*ptr = (Cisco *)page(i);

		if (ptr != NULL)
			ptr->readCisco(out);
	}
}


/*      */
void
Manager::readImage(const QString &path, QByteArray &img)
{
	QStringList	lst(QStringList::split(',', path, FALSE));
	Cisco		*ptr;

	ptr = findCisco(lst[0].lower());
	if (ptr != NULL) {
		lst.pop_front();
		ptr->readImage(img, lst);
	}
}


/*
 *    ,    
 *  NULL   
 */
Cisco *
Manager::findCisco(const QString &host)
{
	int	i, cnt = count();
	Cisco	*ptr, *ret = NULL;

	for (i = 0; (i < cnt) && (ret == NULL); i++) {
		ptr = (Cisco *)page(i);
		if ((ptr != NULL) && (ptr->host().lower() == host))
			ret = ptr;
	}

	return (ret);
}

//-----------------------------------------------------------------------------

HttpServer::HttpServer(Manager *parent)
	:QServerSocket(HTTP_PORT, 100, parent)
{

	mng = parent;
	list.setAutoDelete(TRUE);
	timer = new QTimer(this);

	connect(timer, SIGNAL(timeout()), this, SLOT(polling()));
	timer->start(100);
}

HttpServer::~HttpServer()
{

	delete timer;
}


void
HttpServer::newConnection(int fd)
{
	ClientHttp	*ptr;

	ptr = new ClientHttp(fd);

	list.append(ptr);
}


/*
 *    ,
 * ӣ   [...] C++  ...  -
 */
void
HttpServer::polling()
{
	ClientHttp	*ptr;

	for (ptr = list.first(); ptr != NULL; ptr = list.next()) {
		ClientHttp::State	st = ptr->state();

		if (st == ClientHttp::HTTP_DONE) {
			/*      */
			ptr->parseData(mng);
			list.remove(ptr);
		}
	}
}

/* EOF */
