/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: manager.h,v 0.1 2009/05/20 14:19:21 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9), Qt manual pages
 *
 * Hacked by:
 */

#ifndef	__MANAGER_H__
#define	__MANAGER_H__

#include "gui.h"
#include "cisco.h"
#include "client_http.h"


class ClientHttp;
class HttpServer;

typedef	QPtrList<ClientHttp>	ClientList;

class Manager:public QTabWidget
{
	Q_OBJECT
public:
	Manager(QWidget *parent = NULL);
	~Manager();

	void	insertCisco(cisco_t&, QSettings *);
	void	loadSettings(QSettings *);
	void	saveSettings(QSettings *);

	void	readCisco(QString&);
	void	readImage(const QString&, QByteArray&);

private:
	HttpServer	*http;

	void	createCisco(const QString&, QSettings *);

	Cisco	*findCisco(const QString&);

signals:
	void	startSound();
	void	stopSound();
};

//-----------------------------------------------------------------------------

class HttpServer:public QServerSocket
{
	Q_OBJECT
public:
	HttpServer(Manager *parent = NULL);
	~HttpServer();

	void	newConnection(int);

private:
	ClientList	list;
	Manager		*mng;
	QTimer		*timer;

private slots:
	void	polling();
};

#endif	/* __MANAGER_H__ */

/* EOF */
