/*
 * Copyright (c) 2009 by Denis Kozadaev (aka denk@RusNet)
 * All rights reserved
 *
 * $Id: player.h,v 0.1 2009/05/22 20:10:12 denis Exp $
 *
 * Author: Denis Kozadaev (denis@tambov.ru)
 * Description:
 *
 * See also: style(9)
 *
 * Hacked by:
 */

#ifndef	__PLAYER_H__
#define	__PLAYER_H__

#include <vorbis/codec.h>
#include <vorbis/vorbisfile.h>

#include "gui.h"

class Player:public QThread
{
public:
	Player(QSettings *);
	virtual ~Player();

	void	setDevice(const QString&);
	void	setMixer(const QString&);
	void	saveSettings(QSettings *);
	void	setMute(bool);
	void	startSound();
	void	stopSound(int&);
	void	setAlarm();
	void	setFile(const QString&);
	void	moveNormal();
	void	setMixerVolume(int, int);

	QString	device()const{return (dsp);}
	QString	mixer()const{return (mix);}
	int	testDevice(const QString&);
	int	testMixer(const QString&);
	bool	isMute()const{return (mute);}
	int	normalVolume()const{return (normal & 0xFF);}
	int	alarmVolume()const{return (alarm & 0xFF);}

private:
	QString		dsp, mix, file;
	int		alarm, normal;
	int		events;	/*     */
	bool		mute;
	QMutex		mtx;
	QWaitCondition	cond;

	void	play(int);
	void	closeDevice(int);
	void	closeMixer(int);
	void	playFile(OggVorbis_File *, int, int);

	int	count();
	int	setupDevice(vorbis_info *);

	/* DSP */
	int	openDevice(const char *);
	int	resetDevice(int);
	int	setChannels(int, int);
	int	setFormat(int, int);
	int	setSpeed(int, int);

	/* MIXER */
	int	openMixer(const char *);
	int	mixerVolume(int, int&);
	int	setVolume(int, int);

protected:
	virtual void	run();
};

#endif	/* __PLAYER_H__ */

/* EOF */
