#include <qapplication.h>
#include <qmessagebox.h>
#include <mainwindow.h>
#include <stdlib.h>
#include <config.h>
#include <port.h>
//------------------------------------------------------------------------------
#define XSize 600
#define YSize 440
#define buf_size 2048
//------------------------------------------------------------------------------
char *buf;
//------------------------------------------------------------------------------
MainWindow::MainWindow(QWidget *parent,char *name):QWidget(parent,name,WStyle_Minimize)
{
  if(open_port(DEVICE))
  {
    QMessageBox::critical(0,"Port Error","  !");
    exit(1);
  }
  if((buf=new char[buf_size])==NULL)
  {
    QMessageBox::critical(0,"Memory Error","  !");
    close_port();exit(1);
  }
  get_UPS_Name();
  setMinimumSize(XSize,YSize);
  setMaximumSize(XSize,YSize);
  resize(XSize,YSize);
  setBackgroundColor(QColor(0,0,0));
  VI=new Widget(0,300,250,280,0," ()",this);
  VI->move(0,0);
  VO=new Widget(0,300,250,280,0," ()",this);
  VO->move(200,0);
  Hz=new Widget(0,70,55,60,0," ()",this);
  Hz->move(400,0);
  VB=new Widget(0,70,55,60,0," ()",this);
  VB->move(0,200);
  TE=new Widget(0,1000,1000,1000,0," ()",this);
  TE->move(200,200);
  BP=new Widget(0,100,80,90,0," (%)",this);
  BP->move(400,200);
  LBox=new QGroupBox(this);
  LBox->setTitle("");
  LBox->setFont(QFont("times",10));
  LBox->setGeometry(0,400,XSize,40);
  L=new QProgressBar(100,LBox);
  L->setCenterIndicator(TRUE);
  L->setProgress(0);
  L->setGeometry(2,15,LBox->width()-4,LBox->height()-17);
  timer=new QTimer(this);
  QObject::connect(timer,SIGNAL(timeout()),this,SLOT(read_UPS()));
  timer->start(100,TRUE);
}
//------------------------------------------------------------------------------
MainWindow::~MainWindow()
{
  timer->stop();
  close_port();
  delete timer;
  delete L;
  delete LBox;
  delete BP;
  delete TE;
  delete VB;
  delete Hz;
  delete VO;
  delete VI;
}
//------------------------------------------------------------------------------
void MainWindow::closeEvent(QCloseEvent *)
{
  qApp->quit();
}
//------------------------------------------------------------------------------
void MainWindow::get_UPS_Name()
{
char INIT[]={89,0},
     CLEAR[]={122,0},
     ID[]={1,0},
     FIRM[]={121,0};
  UPS_get_param(INIT);
  UPS_get_param(CLEAR);
  UPS_get_param(ID);
QString s=QString(buf);
  UPS_get_param(FIRM);
  s+=QString(" ");s+=QString(buf);
  setCaption(QString("UPS ")+s+QString(" (")+QString(DEVICE)+QString(")"));
}
//------------------------------------------------------------------------------
void MainWindow::read_UPS()
{
char INPUT[]={76,0},
     OUTPUT[]={79,0},
     HZ[]={70,0},
     BAT[]={66,0},
     TIME[]={106,0},
     LOAD[]={80,0},
     BAT_B[]={102,0};
  UPS_get_param(INPUT);VI->setValue(int(atof(buf)));
  UPS_get_param(OUTPUT);VO->setValue(int(atof(buf)));
  UPS_get_param(HZ);Hz->setValue(int(atof(buf)));
  UPS_get_param(BAT);VB->setValue(int(atof(buf)));
  UPS_get_param(TIME);TE->setValue(int(atof(buf)));
  UPS_get_param(BAT_B);BP->setValue(int(atof(buf)));
  UPS_get_param(LOAD);L->setProgress(int(atof(buf)));
  timer->start(100,TRUE);
}
//------------------------------------------------------------------------------
void MainWindow::UPS_get_param(char *com)
{
  write_port(com);
  read_port(buf,buf_size-1);
}
//------------------------------------------------------------------------------
