#include <fcntl.h>
#include <sys/termios.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

int sio;

int open_port(char *com)
{
struct termios pm;
  if((sio=open(com,O_RDWR|O_EXCL|O_NONBLOCK,0))==-1)
  {
    sio=0;
    return 1;
  }
  if(tcgetattr(sio,&pm)==-1)
  {
    close(sio);
    sio=0;
    return 2;
  }
  cfmakeraw(&pm);
  cfsetispeed(&pm,B2400);
  cfsetospeed(&pm,B2400);
  pm.c_cflag|=CLOCAL;
  if(tcsetattr(sio,TCSANOW,&pm)==-1)
  {
    close(sio);
    sio=0;
    return 3;
  }
  return 0;
}
int close_port()
{
  if(!sio)return 1;
  close(sio);
  return 0;
}
int write_port(char *data)
{
int i;
  if(!sio)return 1;
  for(i=0;data[i];i++)
    if(write(sio,&data[i],1)<1)return 1;
  return 0;
}
int read_port(char *data,unsigned l)
{
int i;
fd_set r;
struct timeval to;
char b;
  if(!sio)return 1;
  for(i=0;i<l;i++)
  {
    FD_ZERO(&r);
    FD_SET(sio,&r);
    to.tv_sec=0;
    to.tv_usec=100000;
    if(select(FD_SETSIZE,&r,0,0,&to)<1)break;
    if(read(sio,&b,1)<1)break;
    if(b=='\n')break;
    data[i]=b;
  }
  data[i]=0x0;
  return 0;
}
