# $Id: Makefile.gnu,v 0.1 2005/01/15 10:22:49 denis Exp $

TARGET= QNetChess
OBJS= main.o mainwindow.o gamesocket.o gameboard.o mainwindow.mo gamesocket.mo\
	gameboard.mo
LOCALE_FILE= $(TARGET)_ru
DFLAGS= -DLOCALE_FILE=\"$(LOCALE_FILE)\"
X11BASE= /usr/X11R6
RM= rm -f
CC= gcc
CXX= g++

MOC= $(QTDIR)/bin/moc
QT_INC= -I$(QTDIR)/include
QT_LIB= -L$(QTDIR)/lib -lqt

CFLAGS+= -O2 -W -Wall -Werror $(DFLAGS) -I$(X11BASE)/include $(QT_INC)
LDFLAGS+= -L$(X11BASE)/lib $(QT_LIB)


.SUFFIXES:	.h .cxx .mo .o .cpp

.h.cxx:
	$(MOC) $< -o $@

.cpp.o:
	$(CXX) $(CFLAGS) -c $< -o $@

.cxx.mo:
	$(CXX) $(CFLAGS) -c $< -o $@


all: $(OBJS)
	$(CXX) $(LDFLAGS) -o $(TARGET) $(OBJS)

clean:
	$(RM) $(OBJS) *.cxx

distclean: clean
	$(RM) $(TARGET)

main.o:			main.cpp
mainwindow.o:		mainwindow.cpp
mainwindow.cpp:		mainwindow.h
mainwindow.mo:		mainwindow.cxx
gamesocket.o:		gamesocket.cpp
gamesocket.cpp:		gamesocket.h
gamesocket.mo:		gamesocket.cxx
gameboard.o:		gameboard.cpp
gameboard.cpp:		gameboard.h
gameboard.mo:		gameboard.cxx
