//------------------------------------------------------------------------------
// File: gameboard.cpp
// Copyright (c) Denis Kozadaev (denis@tambov.ru)
//------------------------------------------------------------------------------
//      gameboard.h
//------------------------------------------------------------------------------
#include <qmessagebox.h>
#include <qpainter.h>
#include <gameboard.h>
#include <gameboard.moc>
#include <stdlib.h>
#include <string.h>
//------------------------------------------------------------------------------
//30x30
//  - 15
#define OFFSET 2
#define USER 1
#define COMP 2
//------------------------------------------------------------------------------
GameBoard::GameBoard(QWidget *parent,char *name):QWidget(parent,name)
{
  setBackgroundColor(black);
  scr=new QPixmap();
  scr->resize(451,451);
  scr->fill(white);
  map=new Cell[900];
  setMouseTracking(TRUE);
  timer=new QTimer(this);
  timer->start(500);last_color=FALSE;
  QObject::connect(timer,SIGNAL(timeout()),this,SLOT(blinkLine()));
}
//------------------------------------------------------------------------------
GameBoard::~GameBoard()
{
  timer->stop();
  delete timer;
  delete map;
  delete scr;
}
//------------------------------------------------------------------------------
void GameBoard::paintEvent(QPaintEvent *e)
{
QPainter *p=new QPainter(this);
  p->drawPixmap(OFFSET,OFFSET,*scr);
  if(drwLine)
  {
    p->setPen(blue);
    p->drawLine(x1+OFFSET,y1+OFFSET,x2+OFFSET,y2+OFFSET);
  }
  if(last_color)p->setPen(black);
    else p->setPen(green);
  p->drawLine(last_x1+OFFSET,last_y1+OFFSET,last_x2+OFFSET,last_y2+OFFSET);
  delete p;
}
//------------------------------------------------------------------------------
void GameBoard::newGame()
{
int y,x,c=230;
  scr->fill(white);
QPainter *p=new QPainter(scr);
  p->setPen(QColor(c,c,c));
  for(y=0;y<15;y++)
  {
    x=y*15;
    p->drawLine(x,225-x,450-x,225-x);
    p->drawLine(x,225+x,450-x,225+x);
    p->drawLine(225-x,x,225-x,450-x);
    p->drawLine(225+x,x,225+x,450-x);
  }
  p->setPen(black);x=210;y=0;
  p->moveTo(x,y);x+=30;p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y+=30;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y+=15;p->lineTo(x,y);x-=30;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x-=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x-=15;
  p->lineTo(x,y);y-=30;p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;
  p->lineTo(x,y);y-=15;p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;
  p->lineTo(x,y);x+=15;p->lineTo(x,y);y-=15;p->lineTo(x,y);
  for(y=0;y<14;y++)
    for(x=0;x<14-y;x++)
    {
      c=y*30;
      setBusy(c+x);
      setBusy(c+29-x);
      c=(29-y)*30;
      setBusy(c+x);
      setBusy(c+29-x);
    }
  setLineBusy(14,15);setLineBusy(43,46);setLineBusy(72,77);
  setLineBusy(101,108);setLineBusy(130,139);setLineBusy(159,170);
  setLineBusy(188,201);setLineBusy(217,232);setLineBusy(246,263);
  setLineBusy(275,294);setLineBusy(304,325);setLineBusy(333,356);
  setLineBusy(362,387);setLineBusy(391,418);setLineBusy(420,449);
  setLineBusy2(450,479);setLineBusy2(481,508);setLineBusy2(512,537);
  setLineBusy2(543,566);setLineBusy2(574,595);setLineBusy2(605,624);
  setLineBusy2(636,653);setLineBusy2(667,682);setLineBusy2(698,711);
  setLineBusy2(729,740);setLineBusy2(760,769);setLineBusy2(791,798);
  setLineBusy2(822,827);setLineBusy2(853,856);setLineBusy2(884,885);
  delete p;update();
  x1=y1=x2=y2=-1;drwLine=FALSE;
  user=0;comp=0;user1=0;
  emit changeInfo(user,comp);
}
//------------------------------------------------------------------------------
void GameBoard::setBusy(int l)
{
  map[l].sym=-1;
  map[l].left=FALSE;
  map[l].right=FALSE;
  map[l].up=FALSE;
  map[l].down=FALSE;
}
//------------------------------------------------------------------------------
void GameBoard::setBusy(int l,char c,int lf,int r,int u,int d,bool test)
{
  if(test&&(map[l].sym!=0))return;
  if(c!=-2)map[l].sym=c;
  if((lf==FALSE)||(lf==TRUE))map[l].left=lf;
  if((r==FALSE)||(r==TRUE))map[l].right=r;
  if((u==FALSE)||(u==TRUE))map[l].up=u;
  if((d==FALSE)||(d==TRUE))map[l].down=d;
}
//------------------------------------------------------------------------------
void GameBoard::setLineBusy(int b,int e)
{
  if(e-b>1)
    for(int i=b+1;i<e;i++)
      setBusy(i,0,TRUE,TRUE,TRUE,TRUE,FALSE);
  setBusy(b,0,FALSE,TRUE,FALSE,TRUE,FALSE);
  setBusy(e,0,TRUE,FALSE,FALSE,TRUE,FALSE);
}
//------------------------------------------------------------------------------
void GameBoard::setLineBusy2(int b,int e)
{
  if(e-b>1)
    for(int i=b+1;i<e;i++)
      setBusy(i,0,TRUE,TRUE,TRUE,TRUE,FALSE);
  setBusy(b,0,FALSE,TRUE,TRUE,FALSE,FALSE);
  setBusy(e,0,TRUE,FALSE,TRUE,FALSE,FALSE);
}
//------------------------------------------------------------------------------
void GameBoard::mouseMoveEvent(QMouseEvent *e)
{
int x=e->x()-OFFSET,y=e->y()-OFFSET;
int xm=x/15,ym=y/15;
  if((xm<0)||(xm>29)||(ym<0)||(ym>29)||(map[ym*30+xm].sym==-1))return;
  drawLine(xm,ym,x,y);
}
//------------------------------------------------------------------------------
void GameBoard::drawLine(int xm,int ym,int x,int y)
{
int xl1=xm*15,yl1=ym*15,xl2=xl1+15,yl2=yl1+15;
int st=3,p=0;
  if(abs(x-xl1)<=st)
  {
    x2=x1=xl1;p=1;//left
    y1=yl1;y2=yl2;
  }
  else if(abs(x-xl2)<=st)
       {
         x2=x1=xl2;p=2;//right
         y1=yl1;y2=yl2;
       }
  else if(abs(y-yl1)<=st)
       {
         x1=xl1;x2=xl2;p=3;//up
         y2=y1=yl1;
       }
  else if(abs(y-yl2)<=st)
       {
         x1=xl1;x2=xl2;p=4;//down
         y2=y1=yl2;
       }
int l=linear(xm,ym);
  switch(p)
  {
    case 1:drwLine=(map[l].left);break;
    case 2:drwLine=(map[l].right);break;
    case 3:drwLine=(map[l].up);break;
    case 4:drwLine=(map[l].down);break;
    default:return;
  }
  if(drwLine)pos=p;
  repaint(FALSE);
}
//------------------------------------------------------------------------------
void GameBoard::mousePressEvent(QMouseEvent *e)
{
  if(!drwLine)return;
  setBusy(e->x()-OFFSET,e->y()-OFFSET,USER);
  if(user==user1)setBusyByComputer();
  else{
        int l=findCell();
        if(isComplete(l))setBusy(l,USER);
      }
  user1=user;
  if((user+comp)==480)
  {
    QString s;
    if(comp>user)s="   .\n  .";
    else if(comp<user)s=".  .";
    else s=".";
    switch(QMessageBox::warning(this,VERSION,s+"\n ?",", ",", ",0,0,0))
    {
      case 0:qApp->quit();break;
      case 1:newGame();break;
    }
  }
}
//------------------------------------------------------------------------------
bool GameBoard::isComplete(int x,int y)
{
int l=linear(x,y);
  return (!map[l].left&&!map[l].right&&!map[l].up&&!map[l].down)&&(map[l].sym==0);
}
//------------------------------------------------------------------------------
bool GameBoard::isComplete(int l)
{
  return (!map[l].left&&!map[l].right&&!map[l].up&&!map[l].down)&&(map[l].sym==0);
}
//------------------------------------------------------------------------------
void GameBoard::setBusy(int x,int y,int t)
{
int xm=x/15,ym=y/15;
  switch(pos)
  {
    case 1:setBusy(linear(xm,ym),-2,FALSE,-1,-1,-1);//left
           if(xm>0)setBusy(linear(xm-1,ym),-2,-1,FALSE,-1,-1);
           break;
    case 2:setBusy(linear(xm,ym),-2,-1,FALSE,-1,-1);//right
           if(xm<29)setBusy(linear(xm+1,ym),-2,FALSE,-1,-1,-1);
           break;
    case 3:setBusy(linear(xm,ym),-2,-1,-1,FALSE,-1);//up
           if(ym>0)setBusy(linear(xm,ym-1),-2,-1,-1,-1,FALSE);
           break;
    case 4:setBusy(linear(xm,ym),-2,-1,-1,-1,FALSE);//down
           if(ym<29)setBusy(linear(xm,ym+1),-2,-1,-1,FALSE,-1);
           break;
  }
bool r=isComplete(xm,ym);
int a=xm*15,b=ym*15;
  if(r)map[linear(xm,ym)].sym=t;
  if(!r&&xm>0)
  {
    r=isComplete(xm-1,ym);
    if(r)map[linear(xm-1,ym)].sym=t;
    a=(xm-1)*15;b=ym*15;
  }
  if(!r&&xm<29)
  {
    r=isComplete(xm+1,ym);
    if(r)map[linear(xm+1,ym)].sym=t;
    a=(xm+1)*15;b=ym*15;
  }
  if(!r&&ym>0)
  {
    r=isComplete(xm,ym-1);
    if(r)map[linear(xm,ym-1)].sym=t;
    a=xm*15;b=(ym-1)*15;
  }
  if(!r&&ym<29)
  {
    r=isComplete(xm,ym+1);
    if(r)map[linear(xm,ym+1)].sym=t;
    a=xm*15;b=(ym+1)*15;
  }
QPainter *p=new QPainter(scr);
  if(r)
    switch(t)
    {
      case USER:p->setPen(QColor(0,0,255));
                p->drawLine(a+4,b+4,a+11,b+11);
                p->drawLine(a+11,b+4,a+4,b+11);
                user++;
                emit changeInfo(user,comp);
                break;
      case COMP:p->setPen(QColor(0,150,255));
                p->drawEllipse(a+4,b+3,8,11);
                comp++;
                emit changeInfo(user,comp);
                break;
    }
  if((pos>0)&&(pos<5))
  {
    if(t==USER)p->setPen(red);
    else if(t==COMP)p->setPen(QColor(0,100,0));
    else p->setPen(black);
    p->drawLine(x1,y1,x2,y2);
    last_x1=x1;last_x2=x2;
    last_y1=y1;last_y2=y2;
    pos=0;
  }
  delete p;
  drwLine=FALSE;
  repaint(FALSE);
}
//------------------------------------------------------------------------------
void GameBoard::setBusy(int l,int t)
{
int x,y;xy(l,x,y);
  setBusy(x*15,y*15,t);
}
//------------------------------------------------------------------------------
int GameBoard::numBusy(int l)
{
int r=0;
  if(map[l].left)r++;
  if(map[l].right)r++;
  if(map[l].up)r++;
  if(map[l].down)r++;
  return r;
}
//------------------------------------------------------------------------------
int GameBoard::numBusy(Cell map)
{
int r=0;
  if(map.left)r++;
  if(map.right)r++;
  if(map.up)r++;
  if(map.down)r++;
  return r;
}
//------------------------------------------------------------------------------
int GameBoard::findCell()
{
int x,y;
  for(int l=0;l<900;l++)
  {
    if(map[l].sym!=0)continue;
    if(numBusy(l)<=1)
    {
      xy(l,x,y);
      if(map[l].left==TRUE)setLeft(x,y);
      else if(map[l].right==TRUE)setRight(x,y);
      else if(map[l].up==TRUE)setUp(x,y);
      else if(map[l].down==TRUE)setDown(x,y);
      return l;
    }
  }
  return -1;
}
//------------------------------------------------------------------------------
int GameBoard::findFreeCell()
{
int x,y,r;
int l1=random()&0x3FF,l;
  while(l1>900)l1-=900;
  for(l=l1;l<900;l++)
  {
    if(map[l].sym!=0)continue;
    if(numBusy(l)>2)
    {
      xy(l,x,y);
      if(x>0)r=numBusy(x-1,y);
      if((r>2)&&(map[l].left!=FALSE)&&(rand()&1))
      {
        setLeft(x,y);
        return l;
      }
      if(x<29)r=numBusy(x+1,y);
      if((r>2)&&(map[l].right!=FALSE)&&(rand()&1))
      {
        setRight(x,y);
        return l;
      }
      if(y>0)r=numBusy(x,y-1);
      if((r>2)&&(map[l].up!=FALSE)&&(rand()&1))
      {
        setUp(x,y);
        return l;
      }
      if(y<29)r=numBusy(x,y+1);
      if((r>2)&&(map[l].down!=FALSE)&&(rand()&1))
      {
        setDown(x,y);
        return l;
      }
    }
  }
  for(l=0;l<900;l++)
  {
    if(map[l].sym!=0)continue;
    if(numBusy(l)>2)
    {
      xy(l,x,y);
      if(x>0)r=numBusy(x-1,y);
      if((r>2)&&(map[l].left!=FALSE))
      {
        setLeft(x,y);
        return l;
      }
      if(x<29)r=numBusy(x+1,y);
      if((r>2)&&(map[l].right!=FALSE))
      {
        setRight(x,y);
        return l;
      }
      if(y>0)r=numBusy(x,y-1);
      if((r>2)&&(map[l].up!=FALSE))
      {
        setUp(x,y);
        return l;
      }
      if(y<29)r=numBusy(x,y+1);
      if((r>2)&&(map[l].down!=FALSE))
      {
        setDown(x,y);
        return l;
      }
    }
  }
  return -1;
}
//------------------------------------------------------------------------------
void GameBoard::setLeft(int x,int y)
{
  pos=1;
  x1=x2=x*15;
  y1=y*15;y2=y1+15;
}
//------------------------------------------------------------------------------
void GameBoard::setRight(int x,int y)
{
  pos=2;
  x1=x2=x*15+15;
  y1=y*15;y2=y1+15;
}
//------------------------------------------------------------------------------
void GameBoard::setUp(int x,int y)
{
  pos=3;
  y1=y2=y*15;
  x1=x*15;x2=x1+15;
}
//------------------------------------------------------------------------------
void GameBoard::setDown(int x,int y)
{
  pos=4;
  y1=y2=y*15+15;
  x1=x*15;x2=x1+15;
}
//------------------------------------------------------------------------------
void GameBoard::setBusyByComputer()
{
int l;
  do
  {
    l=findCell();
    if(l!=-1)
    {
      setBusy(l,COMP);
      continue;
    }
    l=findFreeCell();
    if(l!=-1)
    {
      setBusy(l,COMP);
      return;
    }
    timer->changeInterval(500);
    l=findMin();
    if(l<0)
      qApp->quit();
    setBusy(l,COMP);
    break;
  }
  while(l!=-1);
}
//------------------------------------------------------------------------------
int GameBoard::findMin()
{
Cell *m1=new Cell[900];
int p=0;
  list=new QList<MinPos>;
  list->setAutoDelete(TRUE);
  list->clear();
  for(int l=0;l<900;l++)
  {
    if((map[l].sym!=0)||(numBusy(l)!=2))continue;
    if(map[l].left)testMap(l,m1,1);
    if(map[l].right)testMap(l,m1,2);
    if(map[l].up)testMap(l,m1,3);
    if(map[l].down)testMap(l,m1,4);
  }
int l=-1,n=900;
  for(MinPos *i=list->first();i;i=list->next())
    if(i->num<n)
    {
      n=i->num;
      l=i->l;
      pos=i->pos;
    }
  delete list;
  delete m1;
int x,y;xy(l,x,y);
  switch(pos)
  {
    case 1:setLeft(x,y);break;
    case 2:setRight(x,y);break;
    case 3:setUp(x,y);break;
    case 4:setDown(x,y);break;
  }
  return l;
}
//------------------------------------------------------------------------------
void GameBoard::testMap(int l,Cell *m,int p)
{
  memcpy(m,map,sizeof(Cell)*900);
  setLine(m,l,FALSE,p);
MinPos t;
  t.l=l;t.pos=p;t.num=findAndSet(m);
  list->append(new MinPos(t));
}
//------------------------------------------------------------------------------
void GameBoard::setLine(Cell *m,int l,bool s,int p)
{
int x,y;xy(l,x,y);
  switch(p)
  {
    case 1:m[l].left=s;
           if(x>0)m[l-1].right=s;
           break;
    case 2:m[l].right=s;
           if(x<29)m[l+1].left=s;
           break;
    case 3:m[l].up=s;
           if(y>0)m[l-30].down=s;
           break;
    case 4:m[l].down=s;
           if(y<29)m[l+30].up=s;
           break;
  }
}
//------------------------------------------------------------------------------
int GameBoard::findAndSet(Cell *map)
{
int x,y,l,n=0;
bool brk=FALSE;
  while(!brk)
  {
    for(l=0;l<900;l++)
    {
      if(map[l].sym!=0)continue;
      if(numBusy(map[l])<=1)
      {
        xy(l,x,y);
        if(map[l].left==TRUE)setLine(map,l,FALSE,1);
        else if(map[l].right==TRUE)setLine(map,l,FALSE,2);
        else if(map[l].up==TRUE)setLine(map,l,FALSE,3);
        else if(map[l].down==TRUE)setLine(map,l,FALSE,4);
        map[l].sym=COMP;
        n++;break;
      }
    }
    brk=(l>=900);
  }
  return n;
}
//------------------------------------------------------------------------------
void GameBoard::blinkLine()
{
  last_color^=1;
  repaint(FALSE);
}
//------------------------------------------------------------------------------
