//------------------------------------------------------------------------------
// File: gameboard.h
// Copyright (c) Denis Kozadaev (denis@tambov.ru)
//------------------------------------------------------------------------------
//  GameBoard        
//------------------------------------------------------------------------------
#ifndef GameBoard_H
#define GameBoard_H
//------------------------------------------------------------------------------
#include <qwidget.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qlist.h>
//------------------------------------------------------------------------------
#define VERSION " "
//------------------------------------------------------------------------------
struct Cell
{
  char sym;
  bool left;
  bool right;
  bool up;
  bool down;
};
//------------------------------------------------------------------------------
struct MinPos
{
  int l;
  int pos;
  int num;
};
//------------------------------------------------------------------------------
class GameBoard:public QWidget
{
  Q_OBJECT
public:
  GameBoard(QWidget *parent=0,char *name=0);
  ~GameBoard();
private:
  bool drwLine,last_color;
  int x1,y1,x2,y2,pos;
  int last_x1,last_x2,last_y1,last_y2;
  int user,comp,user1;
  QPixmap *scr;
  QList <MinPos> *list;
  QTimer *timer;
  Cell *map;
  void setBusy(int);
  void setBusy(int,char,int,int,int,int,bool test=TRUE);
  void setLineBusy(int,int);
  void setLineBusy2(int,int);
  void drawLine(int,int,int,int);
  int linear(int x,int y){return y*30+x;}
  void xy(int l,int &x,int &y){y=l/30;x=l-y*30;}
  bool isComplete(int,int);
  bool isComplete(int);
  void setBusy(int,int,int);
  void setBusy(int,int);
  int findCell();
  int findFreeCell();
  int numBusy(int);
  int numBusy(Cell);
  int numBusy(int x,int y){return numBusy(linear(x,y));}
  void setLeft(int,int);
  void setRight(int,int);
  void setUp(int,int);
  void setDown(int,int);
  void setBusyByComputer();
  int findMin();
  void testMap(int,Cell *,int);
  void setLine(Cell *,int,bool,int);
  int findAndSet(Cell *);
protected:
  void paintEvent(QPaintEvent *);
  void mouseMoveEvent(QMouseEvent *);
  void mousePressEvent(QMouseEvent *);
public slots:
  void newGame();
private slots:
  void blinkLine();
signals:
  void changeInfo(int,int);
};
//------------------------------------------------------------------------------
#endif	//gameboard.h
//------------------------------------------------------------------------------
