//------------------------------------------------------------------------------
// File: mainwindow.cpp
// Copyright (c) Denis Kozadaev (denis@tambov.ru)
//------------------------------------------------------------------------------
//      mainwindow.h
//------------------------------------------------------------------------------
#include <qpainter.h>
#include <mainwindow.h>
#include <mainwindow.moc>
//------------------------------------------------------------------------------
const int XSize=640,YSize=455;
//------------------------------------------------------------------------------
QFont stdfont("times",11,QFont::Normal);
//------------------------------------------------------------------------------
MainWindow::MainWindow(QWidget *parent,char *name):QWidget(parent,name,WStyle_Minimize)
{
  setCaption(VERSION);
  resize(XSize,YSize);
  setMinimumSize(XSize,YSize);
  setMaximumSize(XSize,YSize);
  gb=new GameBoard(this);
  gb->setGeometry(0,0,455,455);
  lab1=new QLabel(this);
  lab1->setFont(stdfont);
  lab1->setAlignment(AlignLeft|AlignVCenter);
  lab1->setGeometry(460,0,100,30);
  lab2=new QLabel(this);
  lab2->setFont(stdfont);
  lab2->setAlignment(AlignLeft|AlignVCenter);
  lab2->setGeometry(460,30,100,30);
  btn=new QPushButton(this);
  btn->setFont(stdfont);
  btn->setText(" ");
  btn->setGeometry(460,90,100,30);
  QObject::connect(gb,SIGNAL(changeInfo(int,int)),this,SLOT(showInfo(int,int)));
  QObject::connect(btn,SIGNAL(clicked()),gb,SLOT(newGame()));
  gb->newGame();showInfo(0,0);
}
//------------------------------------------------------------------------------
MainWindow::~MainWindow()
{
  delete lab2;
  delete lab1;
  delete gb;
}
//------------------------------------------------------------------------------
void MainWindow::showInfo(int u,int c)
{
  lab1->setText(": "+QString::number(u));
  lab2->setText(": "+QString::number(c));
}
//------------------------------------------------------------------------------
void MainWindow::paintEvent(QPaintEvent *)
{
QPainter *p=new QPainter(this);
  p->setPen(black);
  p->drawRect(460,YSize-32,XSize-460,32);
  p->setPen(white);p->setBrush(white);
  p->drawRect(461,YSize-31,XSize-462,10);
  p->setPen(blue);p->setBrush(blue);
  p->drawRect(461,YSize-21,XSize-462,10);
  p->setPen(red);p->setBrush(red);
  p->drawRect(461,YSize-11,XSize-462,10);
  delete p;
}
//------------------------------------------------------------------------------
