//ComBot, Copyright (C) 2005 ArtX
#include <floatfann.h>

#ifdef _WIN32
  #define LoadPng myLoadPng
  #define SavePng mySavePng
#endif
#ifndef _WIN32
  #define LoadPng myLoadPngUnix
  #define SavePng mySavePngUnix
#endif

namespace Recognizer
{
void segmentationX();
void segmentationY(int, int);
void SaveSegments(char *prefixfiles);
void antibackground();
void dust();
void PicToTrainFile(char *PicFile, char *DataFile);
void PicToArray(char *PicFile, int *array);
void GeneratePics(char *pathToPic, char *SavePathPrefix);
int Recognize(char *FilePic, char *FileAnn);
gdImagePtr myLoadPng(char *filename);
gdImagePtr myLoadPngUnix(char *filename);
void mySavePng(char *filename, gdImagePtr img);
void mySavePngUnix(char *filename, gdImagePtr img);

int ToInt(char *str);

gdImagePtr im;
int xSize=0, ySize=0, DataSize=0;
int CntX=0, CntY=0, CntColor=0;
int BlackColor, pixelColor[999999];
int xSeg1[15], ySeg1[15], xSeg2[15], ySeg2[15], SegCnt=0, flagClean=0;
const int imResultSx=35, imResultSy=35, antibackgroundSens=20;
int tmpColor, CntYColor=0;  


void segmentationY(int X1input, int X2input)
{
  tmpColor=BlackColor;
  flagClean=0;
  for(int yCnt=0;(tmpColor==BlackColor); yCnt++)
  {
    for(int xCnt=X1input; xCnt<=X2input; xCnt++)
	{
	  tmpColor = gdImageGetPixel(im, xCnt, yCnt);
	  if( tmpColor != BlackColor )
	  {
	    ySeg1[SegCnt] = yCnt;
		break;
	  }
    }
  }
  tmpColor=BlackColor;
  for(int yCnt=ySize-1;(tmpColor==BlackColor); yCnt--)
  {
    for(int xCnt=X1input; xCnt<=X2input; xCnt++)
	{
	  tmpColor = gdImageGetPixel(im, xCnt, yCnt);
	  if( tmpColor != BlackColor )
	  {
	    ySeg2[SegCnt] = yCnt+1;
		break;
	  }
    }
  }
}


void segmentationX()
{
  for(int xCnt=1; xCnt<xSize; xCnt++)
  {
    CntYColor=0;
    for(int yCnt=0; yCnt<ySize; yCnt++)
	{
	  tmpColor = gdImageGetPixel(im, xCnt, yCnt);
	  if(flagClean == 0) 
	  { 
	    if( tmpColor != BlackColor )
		{
		  flagClean=1;
		  xSeg1[SegCnt] = xCnt;
          CntYColor=1;
		}
	  }
	  else
	  { if(tmpColor != BlackColor) CntYColor++; }
	}
	if(CntYColor == 0 && flagClean == 1)
	{
	  flagClean=0;
	  xSeg2[SegCnt] = xCnt; segmentationY(xSeg1[SegCnt], xSeg2[SegCnt]);
	  SegCnt++; 
	}
  }
}



void antibackground()
{
  int Cnt1=0, Cnt2=0, CntHowmuch=0;
  while(Cnt1 <= DataSize)
  {
    while(Cnt2 <= DataSize)
	{
	  if( pixelColor[Cnt1] == pixelColor[Cnt2] ) CntHowmuch++;
	  Cnt2++;
	}
	if( CntHowmuch > antibackgroundSens ) //     n-
	{
	  for(int cnt=0; cnt < DataSize; cnt++)
	  {
	    int x=0,y=0;
		y = cnt/xSize; x = cnt-(y*xSize);
	    if( pixelColor[cnt] == pixelColor[Cnt1] ) gdImageSetPixel(im, x, y, BlackColor);
	  }
	}
	CntHowmuch=0;
	Cnt2=0;
	Cnt1++;
  }
}

void dust()
{
  int pixelColorAround[8], pixelCenter;
  for(int cnt=0; cnt < DataSize; cnt++)
  {
    int x=0,y=0, flag=0;
	y = cnt/(xSize-1); x = cnt-(y*(xSize-1));
	pixelCenter = gdImageGetPixel(im, x, y);
    pixelColorAround[0] = gdImageGetPixel(im, x-1, y);
    pixelColorAround[1] = gdImageGetPixel(im, x-1, y-1);
	pixelColorAround[2] = gdImageGetPixel(im, x, y-1);
	pixelColorAround[3] = gdImageGetPixel(im, x+1, y+1);
	pixelColorAround[4] = gdImageGetPixel(im, x+1, y);
	pixelColorAround[5] = gdImageGetPixel(im, x+1, y-1);
	pixelColorAround[6] = gdImageGetPixel(im, x, y+1);
	pixelColorAround[7] = gdImageGetPixel(im, x-1, y+1);
	for(int pixCnt=0; pixCnt!=8; pixCnt++) 
	{ 
	  if( pixelColorAround[pixCnt] != BlackColor ) 
	  flag=1; 
	}
	if( ( pixelCenter != BlackColor ) && (flag==0) ) gdImageSetPixel(im, x, y, BlackColor);
  }
}

gdImagePtr myLoadPng(char *filename)
{
  FILE *in;
  struct stat stat_buf;
  gdImagePtr img;
  in = fopen(filename, "rb");
  if (!in) {
    /* Error */
  }
  if (fstat(fileno(in), &stat_buf) != 0) {
    /* Error */
  }
  /* Read the entire thing into a buffer 
    that we allocate */
  char *buffer = (char *)malloc(stat_buf.st_size);
  if (!buffer) {
    /* Error */
  }
  if (fread(buffer, 1, stat_buf.st_size, in) 
    != stat_buf.st_size) 
  {
    /* Error */
  }
  img = gdImageCreateFromPngPtr(stat_buf.st_size, buffer);
  /* WE allocated the memory, WE free 
    it with our normal free function */
  free(buffer);
  fclose(in);
  return img;
} 

void mySavePng(char *filename, gdImagePtr img)
{
  FILE *out;
  int size;
  char *data;
  out = fopen(filename, "wb");
  if (!out) {
    /* Error */
  }
  data = (char *) gdImagePngPtr(img, &size);
  if (!data) {
    /* Error */
  }
  if (fwrite(data, 1, size, out) != size) {
    /* Error */
  }
  if (fclose(out) != 0) {
    /* Error */
  }
  gdFree(data);  
}

void PicToTrainFile(char *PicFile, char *DataFile)
{
  gdImagePtr imTemp = LoadPng(PicFile);
  const int SizeData = imResultSx*imResultSy;
  int DataForTrain[SizeData], CntData=0;
  char strSize[11]="", strTrainInfo[40]="";
  FILE *file;
  file = fopen(DataFile, "w+");
  sprintf(strSize, "%i", SizeData);
  strcat(strTrainInfo,"1 "); strcat(strTrainInfo,strSize); strcat(strTrainInfo," 10");
  fputs(strTrainInfo, file); fputc('\n', file);
  for(int cntYdata=0; cntYdata<imResultSy; cntYdata++)
  {
    for(int cntXdata=0; cntXdata<imResultSx; cntXdata++)
	{
		int tmp = gdImageGetPixel(imTemp, cntXdata, cntYdata);
		if( !(cntYdata==0 && cntXdata==0) ) fputc(' ', file);
		if( tmp == 0 ) { DataForTrain[CntData]=0; fputc('0', file);  printf("%i",0); }
		else { DataForTrain[CntData]=1; fputc('1', file); printf("%i",1); }
		CntData++;
	}
    printf("\n","");
  }
  char answer = getchar();//getch()?
  fputc('\n', file);
  for(int cnt=0;cnt<10;cnt++)
  {
    if(cnt != 0) fputc(' ', file);
    if( cnt == atol(&answer) ) fputc('1', file);
	else fputc('0', file);
  }
  fputc('\n', file);
  gdImageDestroy(imTemp);
  fclose(file);
}

void PicToArray(char *PicFile, int *array)
{
  gdImagePtr imTemp = LoadPng(PicFile);
  const int SizeData = imResultSx*imResultSy;
  int DataForTrain[SizeData], CntData=0;
  for(int cntYdata=0; cntYdata<imResultSy; cntYdata++)
  {
    for(int cntXdata=0; cntXdata<imResultSx; cntXdata++)
	{
		int tmp = gdImageGetPixel(imTemp, cntXdata, cntYdata);
		if( tmp == 0 ) 
		{ 
		  DataForTrain[CntData]=0; *array = 0; array++; 
		}
		else 
		{ 
		  DataForTrain[CntData]=1; 
		  *array = 1; array++;
		}
		CntData++;
	}
  }
  gdImageDestroy(imTemp);
}


void SaveSegments(char *prefixfiles)
{
  gdImagePtr imResult;
  for(int cnt=0; cnt<SegCnt; cnt++)
  {
    imResult = gdImageCreate(imResultSx, imResultSy);
    gdImageColorAllocate(imResult, 255, 0, 0);
    gdImageCopy(imResult, im, imResultSx/4, imResultSy/4, xSeg1[cnt], ySeg1[cnt], 
		xSeg2[cnt]-xSeg1[cnt], ySeg2[cnt]-ySeg1[cnt]);
	char str[2] = "";
	char strfile[150]="";
	sprintf(str,"%i",cnt);
	strcat(strfile, prefixfiles); strcat(strfile,str); strcat(strfile, ".png");
    SavePng(strfile, imResult);
	gdImageDestroy(imResult);
  }
}

void GeneratePics(char *pathToPic, char *SavePathPrefix)
{
  xSize=0, ySize=0, DataSize=0;
  CntX=0, CntY=0, CntColor=0;
  SegCnt=0, flagClean=0;
  CntYColor=0;

  im = LoadPng(pathToPic); //    
  // 
  BlackColor = gdImageColorAllocate(im, 255, 0, 0);
  xSize = im->sx; 
  ySize = im->sy;
  DataSize = xSize * ySize;

  // 
  gdImageLine(im, 0, 0, xSize-1, 0, BlackColor);
  gdImageLine(im, 0, 0, 0, ySize-1, BlackColor);
  gdImageLine(im, xSize-1, 0, xSize-1, ySize-1, BlackColor);
  gdImageLine(im, 0, ySize-1, xSize-1, ySize-1, BlackColor);
  //  pixelColor[]    
  while(CntColor <= DataSize)
  {
    if(CntX >= xSize){ CntX=0; CntY++; }
    pixelColor[CntColor] = gdImageGetPixel(im, CntX, CntY);
	CntColor++;
	CntX++;
  }
  //       
  antibackground();
  // (  )
  dust();
  //
  segmentationX();
  //    
  SaveSegments(SavePathPrefix);
  gdImageDestroy(im);
}


int Recognize(char *FilePic, char *FileAnn)
{
  int DataFromPic[imResultSx*imResultSy]; 
  float out_numbers[10];
  PicToArray(FilePic, DataFromPic);
  fann_type *calc_out;
  fann_type input[imResultSx*imResultSy];
  struct fann *ann = fann_create_from_file(FileAnn);
  for(int cnt=0;cnt<imResultSx*imResultSy;cnt++)
  {
    input[cnt] = DataFromPic[cnt];
  }
  calc_out = fann_run(ann, input);
  /*for(int cnt=0,cnt2=0;cnt<imResultSx*imResultSy;cnt++)
  { 
    cnt2++;printf("%i", DataFromPic[cnt]); if(cnt2==imResultSx){cnt2=0;printf("\n", "");}
  }*/
  for(int cnt=0;cnt<10;cnt++){ out_numbers[cnt] = calc_out[cnt]; }
  fann_destroy(ann);
  int flag;
  for(int cnt=0; cnt<10; cnt++)
  {
    flag=0;
    for(int cnt2=0; cnt2<10; cnt2++)
	{
	  if(cnt == cnt2) continue;
	  if( out_numbers[cnt] < out_numbers[cnt2] ) flag=1;
	}
	if(flag == 0) return cnt;
  }
  return 0;
}

int ToInt(char *str)
{
  int result=0, cnt=0;
  while(str[cnt] != '1')
  {
    cnt++; if(str[cnt] != ' ') result++;
  }
  return result;
}

gdImagePtr myLoadPngUnix(char *filename)
{
  gdImagePtr img;
  FILE *file = fopen(filename,"rb");
  img = gdImageCreateFromPng(file);
  fclose(file);
  return img;
}

void mySavePngUnix(char *filename, gdImagePtr img)
{
  FILE *file = fopen(filename,"wb");
  gdImagePng(img, file);
  fclose(file);
}

}//close namespace
