--
--  Copyright (c) 2004
--      Progressive Software Engineering Company
--

DROP TABLE IF EXISTS GOODS_GROUPS;
CREATE TABLE GOODS_GROUPS
(
    IDENT INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
    NAME VARCHAR (256) NOT NULL
) CHARACTER SET UTF8;

DROP TABLE IF EXISTS GOODS;
CREATE TABLE GOODS
(
    IDENT INT NOT NULL UNIQUE,
    NAME VARCHAR(128) NOT NULL UNIQUE,
    COST_PRICE DOUBLE(5,2) NOT NULL,
    PRICE DOUBLE(5,2) NOT NULL,
    PRICE_DT DATE NOT NULL,
    QUANTITY INT NOT NULL,
    GRP INT NOT NULL
) CHARACTER SET UTF8;

DROP TABLE IF EXISTS BUYS;
CREATE TABLE BUYS
(
    BUY_DATE DATETIME NOT NULL,
    GOODS_ID INT NOT NULL,
    QUANTITY INT NOT NULL,
    PRICE DOUBLE(5,2) NOT NULL
) CHARACTER SET UTF8;

DROP TABLE IF EXISTS SELLS;
CREATE TABLE SELLS
(
    SELL_DATE DATETIME NOT NULL,
    GOODS_ID INT NOT NULL,
    QUANTITY INT NOT NULL,
    PRICE DOUBLE(5,2) NOT NULL,
    PROFIT DOUBLE(5,2) NOT NULL
) CHARACTER SET UTF8;

DROP TABLE IF EXISTS DEBTORS;
CREATE TABLE DEBTORS
(
    IDENT INT NOT NULL PRIMARY KEY AUTO_INCREMENT,
    NAME VARCHAR(128) NOT NULL UNIQUE,
    ADDRESS VARCHAR(128) NOT NULL,
    H_PHONE VARCHAR(64) NOT NULL,
    M_PHONE VARCHAR(64) NOT NULL
) CHARACTER SET UTF8;

DROP TABLE IF EXISTS DEBTS;
CREATE TABLE DEBTS
(
    DEBTOR INT NOT NULL,
    GOODS_ID INT NOT NULL,
    QUANTITY INT NOT NULL,
    PRICE DOUBLE(5,2) NOT NULL,
    COST_PRICE DOUBLE(5,2) NOT NULL,
    PRIMARY KEY(DEBTOR, GOODS_ID)
) CHARACTER SET UTF8;

