/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <qtable.h>

#include "acc2html.h"

using std::ofstream;

void dump_account_table(ofstream & file, QTable *table, const char *descr)
{
    file << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
            "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"DTD/xhtml1-strict.dtd\">\n"
            "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
            "<head>\n"
            "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n"
            "<meta name=\"Generator\" content=\"The Panther - CShop smart shoping utility v0.01\" />\n";

    if (!descr)
        file << "<title>The Panther - smart shoping ...</title>\n";
    else
        file << "<title>" << descr << "</title>";

    file << "</head>\n<body>"
            "<table cellpadding=\"2\" cellspacing=\"2\" border=\"1\">\n";

    std::string decoder;
    QHeader *table_header = table->horizontalHeader();

    for (int i = 0; i < table->numCols(); i++)
    {
        decoder = table_header->label(i).utf8();

        file << "<th>" << decoder << "</th>";
    }

    for (int i = 0; i < table->numRows(); i++)
    {
        file << "<tr>\n";

        for (int j = 0; j < table->numCols(); j++)
        {
            QTableItem *item = table->item(i, j);

            if (item)
            {
                decoder = item->text().utf8();
                file << "<td>" << decoder << "</td>";
            }
            else
                file << "<td>&nbsp;</td>";
        }

        file << "</tr>\n";
    }

    file << "</table></body></html>\n";
}

