/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qdatetimeedit.h>
#include <qspinbox.h>
#include <qframe.h>
#include <qhbox.h>
#include <qpushbutton.h>

#include <climits>

#include "accountinfo.h"
#include "common.h"

AccountInfoDialog::AccountInfoDialog(QWidget *parent) : QDialog(parent)
{
    setCaption(ENCODE("Формирование отчета ..."));

    QGridLayout *layout = new QGridLayout(this, 1, 1, 5, 5);
    QGroupBox *groupBox = new QGroupBox(this);

    layout->addWidget(groupBox, 0, 0);

    layout = new QGridLayout(groupBox, 1, 1, 5, 5);

    QLabel *label = new QLabel(ENCODE("С:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 0, 0);

    label = new QLabel(ENCODE("По:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 1, 0);

    check = new QCheckBox(ENCODE("Товар:"), groupBox);
    check->setChecked(false);
    layout->addWidget(check, 2, 0);
    connect(check, SIGNAL(toggled(bool)), this, SLOT(slot_checkToggled(bool)));

    dt_edit1 = new QDateTimeEdit(QDateTime::currentDateTime(), groupBox);
    dt_edit1->setAutoAdvance(true);
    layout->addMultiCellWidget(dt_edit1, 0, 0, 1, 3);

    dt_edit2 = new QDateTimeEdit(QDateTime::currentDateTime(), groupBox);
    dt_edit2->setAutoAdvance(true);
    layout->addMultiCellWidget(dt_edit2, 1, 1, 1, 3);

    spin = new QSpinBox(0, INT_MAX, 1, groupBox);
    spin->setEnabled(false);
    layout->addWidget(spin, 2, 1);

    QSpacerItem *spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
    layout->addItem(spacer, 2, 2);

    spacer = new QSpacerItem(0, 0, QSizePolicy::Maximum, QSizePolicy::Expanding);
    layout->addMultiCell(spacer, 3, 3, 0, 3);

    QFrame *frame = new QFrame(groupBox);

    frame->setGeometry(QRect(10, 150, 280, 5));
    frame->setFrameShape(QFrame::HLine);
    layout->addMultiCellWidget(frame, 4, 4, 0, 3);

    spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
    layout->addMultiCell(spacer, 4, 4, 0, 2);

    QHBox *hBox = new QHBox(groupBox);

    hBox->setSpacing(3);

    QPushButton *button = new QPushButton(ENCODE("Создать"), hBox);
    connect(button, SIGNAL(clicked()), this, SLOT(accept()));

    button = new QPushButton(ENCODE("Отменить"), hBox);

    connect(button, SIGNAL(clicked()), this, SLOT(reject()));
    layout->addWidget(hBox, 5, 3);

    adjustSize();
    clearWState(WState_Polished);

    dt_edit1->setFocus();
}

void AccountInfoDialog::slot_checkToggled(bool on)
{
    spin->setEnabled(on);
}

bool AccountInfoDialog::getInfo(int & id, std::string & from_date, std::string & to_date,
                                std::string & from_time, std::string & to_time, QWidget *parent)
{
    std::auto_ptr<AccountInfoDialog> dialog(new AccountInfoDialog(parent));

    if (dialog->exec() == QDialog::Accepted)
    {
        dialog->check->isChecked() ? id = dialog->spin->value() : id = -1;

        from_date = dialog->dt_edit1->dateTime().date().toString(Qt::ISODate);
        to_date = dialog->dt_edit2->dateTime().date().toString(Qt::ISODate);

        from_time = dialog->dt_edit1->dateTime().time().toString(Qt::ISODate);
        to_time = dialog->dt_edit2->dateTime().time().toString(Qt::ISODate);

        return true;
    }

    return false;
}

