/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <unistd.h>

#include <qaction.h>
#include <qlayout.h>
#include <qtable.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qfiledialog.h>
#include <qmessagebox.h>

#include <fstream>

#include "common.h"
#include "accountwin.h"
#include "acc2html.h"

using std::ofstream;

SellAccountWindow::SellAccountWindow(const sell_account_info_t & sinfo, QWidget *parent) :
    QMainWindow(parent, 0,  WType_TopLevel | WDestructiveClose), profit_sum(0), cash(0)
{
    setCaption(ENCODE("Отчет о продажах"));
    setIcon(QPixmap("pic/log_32x32.png"));
    setCentralWidget(new QWidget(this));

    // setup menubar ...
    QPopupMenu *filePopup = new QPopupMenu(this);

    QAction *action = new QAction(QIconSet(QPixmap("pic/filesave_24x24.png")), ENCODE("&Сохранить"), CTRL+Key_S, this);
    connect(action, SIGNAL(activated()), this, SLOT(slot_saveAccount()));
    action->addTo(filePopup);

    filePopup->insertSeparator();

    action = new QAction(QIconSet(QPixmap("pic/fileclose_24x24.png")), ENCODE("Закрыть"), 0, this);
    connect(action, SIGNAL(activated()), this, SLOT(close()));
    action->addTo(filePopup);

    menuBar()->insertItem(ENCODE("&Файл"), filePopup);
    // ---

    // ---

    QGridLayout *layout = new QGridLayout(centralWidget(), 1, 1, 0, 0);

    table = new QTable(0, 7, centralWidget());
    table->setSelectionMode(QTable::SingleRow);

    table->verticalHeader()->hide();
    table->setLeftMargin(0);

    QHeader *table_header = table->horizontalHeader();

    table_header->setLabel(DateCol, ENCODE("Дата"));
    table->setColumnWidth(DateCol, 140);

    table_header->setLabel(IdCol, ENCODE("Идентификатор"));
    table->setColumnWidth(IdCol, 50);

    table_header->setLabel(QuantityCol, ENCODE("Кол-во"));
    table->setColumnWidth(QuantityCol, 50);

    table_header->setLabel(PriceCol, ENCODE("Цена"));
    table->setColumnWidth(PriceCol, 70);

    table_header->setLabel(PriceSumCol, ENCODE("Сумма"));
    table->setColumnWidth(PriceSumCol, 70);

    table_header->setLabel(ProfitCol, ENCODE("Прибыль"));
    table->setColumnWidth(ProfitCol, 70);

    table_header->setLabel(ProfitSumCol, ENCODE("Сумма прибыли"));
    table->setColumnWidth(ProfitSumCol, 70);

    layout->addWidget(table, 0, 0);

    // fill table ...

    table->setNumRows(sinfo.size() + 1);

    int row = 0;
    char sum_str[8];

    for (sell_account_info_t::const_iterator i = sinfo.begin(); i != sinfo.end(); i++)
    {
        table->setItem(row, DateCol, new QTableItem(table, QTableItem::Never, ENCODE(i->date.c_str())));
        table->setItem(row, IdCol, new QTableItem(table, QTableItem::Never, ENCODE(i->ident.c_str())));
        table->setItem(row, QuantityCol, new QTableItem(table, QTableItem::Never, ENCODE(i->quantity.c_str())));
        table->setItem(row, PriceCol, new QTableItem(table, QTableItem::Never, ENCODE(i->price.c_str())));

        int quant = (int)strtol(i->quantity.c_str(), 0, 10);
        float ps = quant * strtof(i->price.c_str(), 0);

        (void)snprintf(sum_str, sizeof(sum_str) - 1, PRICE_FORMAT, ps);
        table->setItem(row, PriceSumCol, new QTableItem(table, QTableItem::Never, sum_str));

        cash += ps;

        table->setItem(row, ProfitCol, new QTableItem(table, QTableItem::Never, ENCODE(i->profit.c_str())));

        ps = quant * strtof(i->profit.c_str(), 0);

        snprintf(sum_str, sizeof(sum_str) - 1, PRICE_FORMAT, ps);
        table->setItem(row, ProfitSumCol, new QTableItem(table, QTableItem::Never, sum_str));

        profit_sum += ps;
        row++;
    }

    table->setItem(sinfo.size(), PriceCol, new QTableItem(table, QTableItem::Never, ENCODE("Касса:")));

    snprintf(sum_str, sizeof(sum_str) - 1, PRICE_FORMAT, cash);
    table->setItem(sinfo.size(), PriceSumCol, new QTableItem(table, QTableItem::Never, sum_str));

    table->setItem(sinfo.size(), ProfitCol, new QTableItem(table, QTableItem::Never, ENCODE("Прибыль:")));

    snprintf(sum_str, sizeof(sum_str) - 1, PRICE_FORMAT, profit_sum);
    table->setItem(sinfo.size(), ProfitSumCol, new QTableItem(table, QTableItem::Never, sum_str));

    table->setCurrentCell(0, 0);

    // ---

    adjustSize();
    clearWState(WState_Polished);

    show();
}

void SellAccountWindow::slot_saveAccount()
{
    std::string decoded_caption;

    decoded_caption = caption().utf8();
    saveAccount(this, table, decoded_caption.c_str());
}

BuyAccountWindow::BuyAccountWindow(const buy_account_info_t & binfo, QWidget *parent) :
    QMainWindow(parent, 0,  WType_TopLevel | WDestructiveClose), price_sum(0)
{
    setCaption(ENCODE("Отчет о закупках"));
    setIcon(QPixmap("pic/log_32x32.png"));
    setCentralWidget(new QWidget(this));

    // setup menubar ...
    QPopupMenu *filePopup = new QPopupMenu(this);

    QAction *action = new QAction(QIconSet(QPixmap("pic/filesave_24x24.png")), ENCODE("&Сохранить"), CTRL+Key_S, this);
    connect(action, SIGNAL(activated()), this, SLOT(slot_saveAccount()));
    action->addTo(filePopup);

    filePopup->insertSeparator();

    action = new QAction(QIconSet(QPixmap("pic/fileclose_24x24.png")), ENCODE("Закрыть"), 0, this);
    connect(action, SIGNAL(activated()), this, SLOT(close()));
    action->addTo(filePopup);

    menuBar()->insertItem(ENCODE("&Файл"), filePopup);
    // ---

    QGridLayout *layout = new QGridLayout(centralWidget(), 1, 1, 0, 0);

    table = new QTable(0, 5, centralWidget());
    table->setSelectionMode(QTable::SingleRow);

    table->verticalHeader()->hide();
    table->setLeftMargin(0);

    QHeader *table_header = table->horizontalHeader();

    table_header->setLabel(DateCol, ENCODE("Дата"));
    table->setColumnWidth(DateCol, 140);

    table_header->setLabel(IdCol, ENCODE("Идентификатор"));
    table->setColumnWidth(IdCol, 50);

    table_header->setLabel(QuantityCol, ENCODE("Кол-во"));
    table->setColumnWidth(QuantityCol, 50);

    table_header->setLabel(PriceCol, ENCODE("Цена"));
    table->setColumnWidth(PriceCol, 70);

    table_header->setLabel(PriceSumCol, ENCODE("Сумма"));
    table->setColumnWidth(PriceSumCol, 70);

    layout->addWidget(table, 0, 0);

    // fill table ...

    table->setNumRows(binfo.size() + 1);

    int row = 0;
    char sum_str[8];

    for (buy_account_info_t::const_iterator i = binfo.begin(); i != binfo.end(); i++)
    {
        table->setItem(row, DateCol, new QTableItem(table, QTableItem::Never, ENCODE(i->date.c_str())));
        table->setItem(row, IdCol, new QTableItem(table, QTableItem::Never, ENCODE(i->ident.c_str())));
        table->setItem(row, QuantityCol, new QTableItem(table, QTableItem::Never, ENCODE(i->quantity.c_str())));
        table->setItem(row, PriceCol, new QTableItem(table, QTableItem::Never, ENCODE(i->price.c_str())));

        int quant = strtol(i->quantity.c_str(), 0, 10);
        float ps = quant * strtof(i->price.c_str(), 0);

        (void)snprintf(sum_str, sizeof(sum_str) - 1, PRICE_FORMAT, ps);
        table->setItem(row, PriceSumCol, new QTableItem(table, QTableItem::Never, sum_str));

        price_sum += ps;
        row++;
    }

    table->setItem(binfo.size(), PriceCol, new QTableItem(table, QTableItem::Never, ENCODE("Касса:")));

    (void)snprintf(sum_str, sizeof(sum_str) - 1, PRICE_FORMAT, price_sum);
    table->setItem(binfo.size(), PriceSumCol, new QTableItem(table, QTableItem::Never, sum_str));

    table->setCurrentCell(0, 0);

    // ---

    adjustSize();
    clearWState(WState_Polished);

    show();
}

void BuyAccountWindow::slot_saveAccount()
{
    std::string decoded_caption;

    decoded_caption = caption().utf8();
    saveAccount(this, table, decoded_caption.c_str());
}

void saveAccount(QWidget *parent, QTable *table, const char *descr)
{
    std::auto_ptr<QFileDialog> dialog(new QFileDialog(parent, 0, true));

    dialog->setShowHiddenFiles(false);
    dialog->setMode(QFileDialog::AnyFile);
    dialog->setFilters(static_cast<QString>("HTML (*.html)"));

    if (dialog->exec() == QDialog::Accepted)
    {
        std::string file;

        file = dialog->selectedFile();

        if (file.size() < 6 || file.compare(file.size() - 5, file.size(), ".html") || file[file.size() - 6] == '/')
        {
            QMessageBox::information(parent, ENCODE("Некорректное имя"),
                ENCODE("Некорректное имя файла !"));

            return;
        }

        if (access(file.c_str(), F_OK) == 0)
        {
            if (QMessageBox::question(parent, ENCODE("Файл существует"),
                                  ENCODE("Такой файл уже существует, переписать его ?"),
                                  ENCODE("Да"), ENCODE("Нет"), QString::null, 1, 1) != 0)
            {
                return; // don't rewrite existing file ...
            }

            if (access(file.c_str(), R_OK | W_OK) != 0)
            {
                QMessageBox::information(parent, ENCODE("Нет прав"), ENCODE("У Вас нет прав на запись этого файла !"));
                return; // permission denied ...
            }
        }

        ofstream accOutStream(file.c_str());

        if (!accOutStream.is_open())
        {
            QMessageBox::information(parent, ENCODE("Ошибка"), ENCODE("Невозможно создать файл !"));
            return; // permission denied ...
        }

        dump_account_table(accOutStream, table, descr);
    }
}

