/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_ACCOUNTWIN_H_
#define _CSHOP_ACCOUNTWIN_H_

#include <qmainwindow.h>

#include "database.h"

class QTable;

class SellAccountWindow : public QMainWindow
{
    Q_OBJECT

  public:
    enum TableCols
    {
        DateCol,
        IdCol,
        QuantityCol,
        PriceCol,
        PriceSumCol,
        ProfitCol,
        ProfitSumCol
    };

    SellAccountWindow(const sell_account_info_t & sinfo, QWidget *parent = 0);

  private:
    QTable *table;
    float profit_sum, cash;

  private slots:
    void slot_saveAccount();
};

class BuyAccountWindow : public QMainWindow
{
    Q_OBJECT

  public:
    enum TableCols
    {
        DateCol,
        IdCol,
        QuantityCol,
        PriceCol,
        PriceSumCol
    };

    BuyAccountWindow(const buy_account_info_t & binfo, QWidget *parent = 0);

  private:
    QTable *table;
    float price_sum;

  private slots:
    void slot_saveAccount();
};

void saveAccount(QWidget *parent, QTable *table, const char *descr = 0);

#endif  // _CSHOP_ACCOUNTWIN_H_

