/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include "adddebtor.h"
#include "common.h"

DebtorInfoHatWidget::DebtorInfoHatWidget(QWidget *parent) : QWidget(parent)
{
    QGridLayout *layout = new QGridLayout(this, 1, 1, 5, 5);

    // ---

    QLabel *label = new QLabel(ENCODE("Имя:"), this);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 0, 0);

    _nameEdit = new QLineEdit(this);
    _nameEdit->setMaxLength(128);
    layout->addWidget(_nameEdit, 0, 1);

    connect(_nameEdit, SIGNAL(returnPressed()), this, SLOT(slot_nameChanged()));
    connect(_nameEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slot_nameTextChanged(const QString &)));

    // ---

    label = new QLabel(ENCODE("Адрес:"), this);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 1, 0);

    _addressEdit = new QLineEdit(this);
    _addressEdit->setMaxLength(128);
    layout->addWidget(_addressEdit, 1, 1);

    connect(_addressEdit, SIGNAL(returnPressed()), this, SLOT(slot_addressChanged()));

    // ---

    label = new QLabel(ENCODE("Дом. тел.:"), this);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 2, 0);

    _phoneEdit = new QLineEdit(this);
    _phoneEdit->setMaxLength(256);
    layout->addWidget(_phoneEdit, 2, 1);

    connect(_phoneEdit, SIGNAL(returnPressed()), this, SLOT(slot_phoneChanged()));

    // ---

    label = new QLabel(ENCODE("Моб. тел.:"), this);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 3, 0);

    _mobEdit = new QLineEdit(this);
    _mobEdit->setMaxLength(64);
    layout->addWidget(_mobEdit, 3, 1);

    connect(_mobEdit, SIGNAL(returnPressed()), this, SLOT(slot_mobileChanged()));

    // ---
}

void DebtorInfoHatWidget::slot_nameTextChanged(const QString & str)
{
    emit nameChanged(str);
}

void DebtorInfoHatWidget::slot_nameChanged()
{
    emit dataChanged(NameData);
}

void DebtorInfoHatWidget::slot_addressChanged()
{
    emit dataChanged(AddressData);
}

void DebtorInfoHatWidget::slot_phoneChanged()
{
    emit dataChanged(hPhoneData);
}

void DebtorInfoHatWidget::slot_mobileChanged()
{
    emit dataChanged(mPhoneData);
}

AddDebtorDialog::AddDebtorDialog(QWidget *parent) : QDialog(parent)
{
    QVBoxLayout *layout = new QVBoxLayout(this, 0);

    hat = new DebtorInfoHatWidget(this);
    layout->addWidget(hat);
    connect(hat, SIGNAL(nameChanged(const QString &)), this, SLOT(statusChanged(const QString &)));

    layout->addItem(new QSpacerItem(0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding));

    QFrame *frame = new QFrame(this);

    frame->setGeometry(QRect(10, 150, 280, 5));
    frame->setFrameShape(QFrame::HLine);
    layout->addWidget(frame);

    QWidget *buttonBox = new QWidget(this);
    QBoxLayout *buttonLayout = new QHBoxLayout(buttonBox, 3);

    buttonLayout->setAutoAdd(true);
    buttonLayout->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum));

    okButton = new QPushButton(ENCODE("Добавить"), buttonBox);
    okButton->setEnabled(false);
    connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));

    QPushButton *button = new QPushButton(ENCODE("Отменить"), buttonBox);
    connect(button, SIGNAL(clicked()), this, SLOT(reject()));

    layout->addWidget(buttonBox);

    resize(QSize(350, 0).expandedTo(minimumSizeHint()));
    clearWState(WState_Polished);
}

void AddDebtorDialog::statusChanged(const QString & str)
{
    okButton->setEnabled(str.length() > 0);
}

