/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_ADDDEBTOR_H_
#define _CSHOP_ADDDEBTOR_H_

#include <qwidget.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qdialog.h>

#include <memory>

class QPushButton;

class DebtorInfoHatWidget : public QWidget
{
    Q_OBJECT

  public:
    enum DataType
    {
        NameData,
        AddressData,
        hPhoneData,
        mPhoneData
    };

    DebtorInfoHatWidget(QWidget *parent = 0);
    virtual ~DebtorInfoHatWidget() { }

    QString name() const { return _nameEdit->text(); }
    void name(const QString & nm) { _nameEdit->setText(nm); }

    QString address() const { return _addressEdit->text(); }
    void address(const QString & ad) { _addressEdit->setText(ad); }

    QString homePhone() const { return _phoneEdit->text(); }
    void homePhone(const QString & hp) { _phoneEdit->setText(hp); }

    QString mobilePhone() const { return _mobEdit->text(); }
    void mobilePhone(const QString & mp) { _mobEdit->setText(mp); }

  private:
    QLineEdit *_nameEdit, *_addressEdit, *_phoneEdit, *_mobEdit;

  private slots:
    void slot_nameTextChanged(const QString & str);
    void slot_nameChanged();
    void slot_addressChanged();
    void slot_phoneChanged();
    void slot_mobileChanged();

  signals:
    void nameChanged(const QString &);
    void dataChanged(const DebtorInfoHatWidget::DataType);
};

class AddDebtorDialog : public QDialog
{
    Q_OBJECT

  public:
    typedef std::auto_ptr<AddDebtorDialog> Ptr;

    AddDebtorDialog(QWidget *parent = 0);
    virtual ~AddDebtorDialog() { }

    const DebtorInfoHatWidget *info() const { return hat; }

  private:
    DebtorInfoHatWidget *hat;
    QPushButton *okButton;

  private slots:
    void statusChanged(const QString & str);
};

#endif  // _CSHOP_ADDDEBTOR_H_

