/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_COMMON_H_
#define _CSHOP_COMMON_H_

#define ENCODE(str)     QObject::trUtf8(str)
#define DEF_LAB_ALIGN   QLabel::AlignVCenter | QLabel::AlignRight

#define PRICE_FORMAT    "%.2f"

#define INT_TO_STR(String, Integer) \
    (void)snprintf(String, sizeof(String) - 1, "%d", Integer)

#define FLOAT_TO_PRICE_STR(String, Price)   \
    (void)snprintf(String, sizeof(String) - 1, PRICE_FORMAT, Price)

bool isDigit(const char *ptr, unsigned int size);

#endif  // _CSHOP_COMMON_H_

