/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <sys/types.h>

#include <unistd.h>
#include <pwd.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qhbox.h>
#include <qtoolbutton.h>
#include <qpushbutton.h>
#include <qfiledialog.h>

#include <mysql/mysql_version.h>

#include <memory>

#include "connwin.h"
#include "common.h"

ConnWin::ConnWin(QWidget *parent, bool modal) : QDialog(parent, 0, modal)
{
    setCaption(ENCODE("Соединение с СУБД ..."));

    QGridLayout *layout = new QGridLayout(this, 1, 1, 5, 5);
    QGroupBox *groupBox = new QGroupBox(this);

    layout->addWidget(groupBox, 0, 0);

    layout = new QGridLayout(groupBox, 1, 1, 5, 5);

    QLabel *label = new QLabel(ENCODE("Адрес:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 0, 0);

    label = new QLabel(ENCODE("Имя:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 1, 0);

    label = new QLabel(ENCODE("Пароль:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 2, 0);

    label = new QLabel(ENCODE("Источник:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 3, 0);

    label = new QLabel(ENCODE("Порт:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 4, 0);

    label = new QLabel(ENCODE("Сокет:"), groupBox);

    label->setAlignment(DEF_LAB_ALIGN);
    layout->addWidget(label, 5, 0);

    dbHostEdit = new QLineEdit(groupBox);

    connect(dbHostEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slot_editHost()));
    layout->addMultiCellWidget(dbHostEdit, 0, 0, 1, 3);
    dbHostEdit->setMinimumWidth(200);

    struct passwd *pw = getpwuid(getuid());

    pw && pw->pw_name ?
        userNameEdit = new QLineEdit(pw->pw_name, groupBox) :
        userNameEdit = new QLineEdit(groupBox);

    connect(userNameEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slot_checkInput()));
    layout->addMultiCellWidget(userNameEdit, 1, 1, 1, 3);

    userPasswordEdit = new QLineEdit(groupBox);

    userPasswordEdit->setEchoMode(QLineEdit::Password);
    layout->addMultiCellWidget(userPasswordEdit, 2, 2, 1, 3);

    dbEdit = new QLineEdit(ENCODE("CShop"), groupBox);

    connect(dbEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slot_checkInput()));
    layout->addMultiCellWidget(dbEdit, 3, 3, 1, 3);

    dbPortSpin = new QSpinBox(0, 50000, 1, groupBox);

    dbPortSpin->setValue(3306);
    layout->addWidget(dbPortSpin, 4, 1);

    QSpacerItem *spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);

    layout->addItem(spacer, 4, 2);

    QHBox *hBox = new QHBox(groupBox);

    hBox->setSpacing(3);

    sockEdit = new QLineEdit(MYSQL_UNIX_ADDR, hBox);

    connect(sockEdit, SIGNAL(textChanged(const QString &)), this, SLOT(slot_editSock()));

    QToolButton *tool_button = new QToolButton(hBox);

    tool_button->setText("...");
    connect(tool_button, SIGNAL(clicked()), this, SLOT(slot_sockSelect()));

    layout->addMultiCellWidget(hBox, 5, 5, 1, 3);

    spacer = new QSpacerItem(0, 0, QSizePolicy::Maximum, QSizePolicy::Expanding);

    layout->addMultiCell(spacer, 6, 6, 0, 3);

    QFrame *frame = new QFrame(groupBox);

    frame->setGeometry(QRect(10, 150, 280, 5));
    frame->setFrameShape(QFrame::HLine);
    layout->addMultiCellWidget(frame, 7, 7, 0, 3);

    spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);

    layout->addMultiCell(spacer, 8, 8, 0, 2);

    hBox = new QHBox(groupBox);

    hBox->setSpacing(3);

    connButton = new QPushButton(ENCODE("Войти"), hBox);

    connButton->setEnabled(false);
    connect(connButton, SIGNAL(clicked()), this, SLOT(accept()));

    QPushButton *button = new QPushButton(ENCODE("Отменить"), hBox);

    connect(button, SIGNAL(clicked()), this, SLOT(reject()));

    layout->addWidget(hBox, 8, 3);

    adjustSize();
    clearWState(WState_Polished);

    slot_checkInput();
}

void ConnWin::slot_editHost()
{
    if (dbHostEdit->text().length())
    {
        sockEdit->blockSignals(true);
        sockEdit->setText("");
        sockEdit->blockSignals(false);
        slot_checkInput();
    }
}

void ConnWin::slot_editSock()
{
    if (sockEdit->text().length())
    {
        dbHostEdit->blockSignals(true);
        dbHostEdit->setText("");
        dbHostEdit->blockSignals(false);
        slot_checkInput();
    }
}

void ConnWin::slot_checkInput()
{
    connButton->setEnabled(((dbHostEdit->text().length() && dbPortSpin->value() > 0) ||
                            sockEdit->text().length()) && userNameEdit->text().length() &&
                           dbEdit->text().length());
}

void ConnWin::slot_sockSelect()
{
    std::auto_ptr<QFileDialog> dialog(new QFileDialog(this, 0, true));

    dialog->setShowHiddenFiles(true);
    dialog->setMode(QFileDialog::ExistingFile);
    dialog->setViewMode(QFileDialog::Detail);

    if (dialog->exec() == QDialog::Accepted)
        sockEdit->setText(dialog->selectedFile());
}

