/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_CONNWIN_H_
#define _CSHOP_CONNWIN_H_

#include <qdialog.h>
#include <qlineedit.h>
#include <qspinbox.h>

#include <string>

class QPushButton;

class ConnWin : public QDialog
{
    Q_OBJECT

  public:
    ConnWin(QWidget *parent = 0, bool modal = false);
    virtual ~ConnWin() { }

    void host(std::string & str) const { str = dbHostEdit->text().utf8(); }
    void login(std::string & str) const { str = userNameEdit->text().utf8(); }
    void password(std::string & str) const { str = userPasswordEdit->text().utf8(); }
    void database(std::string & str) const { str = dbEdit->text().utf8(); }
    void socket(std::string & str) const { str = sockEdit->text().utf8(); }

    unsigned int port() const { return dbPortSpin->value(); }

  private:
    QLineEdit *dbHostEdit, *userNameEdit, *userPasswordEdit,
              *dbEdit, *sockEdit;

    QSpinBox *dbPortSpin;
    QPushButton *connButton;

  private slots:
    void slot_editHost();
    void slot_editSock();
    void slot_checkInput();
    void slot_sockSelect();
};

#endif  // _CSHOP_CONNWIN_H_

