#
#   Copyright (c) 2004
#       Progressive Software Engineering Company
#

AR=             ar -crlf
RM=             rm -f
CP=             cp
RMDIR=          $(RM) -r
MKDIR=          mkdir -p
LINK=           ln -s
INSTALL_BIN=    install
INSTALL_DATA=   $(INSTALL_BIN) -m 644
LDCONFIG=       ldconfig
MOC=            moc
DOC=            kdoc

CXX=            c++
CXXFLAGS=       -std=c++98 -Wall -pipe -O3

ifeq "$(OSTYPE)" "linux"
    # Linux C++ libraries shows the best correlation with ANSI C++ standatd
    CXXFLAGS += -ansi
endif

INCLUDES=
LDLIBS=

PTHREAD_INC=
PTHREAD_LIB=    -pthread

MYSQL_INC=	-I/usr/include/mysql/
MYSQL_LIB=	-L/usr/lib/mysql -lmysqlclient

XML_INC=        -I/usr/include/gnome-xml/
XML_LIB=        -lxml

QT_INC=         -I/usr/lib/qt3/include/
QT_LIB=         -L/usr/lib/qt3/lib/ -lqt-mt

.h.cpp: $<
	$(MOC) -o $@ $<
	$(CXX) $(CXXFLAGS) $(INCLUDES) -c $@ -o $(@:.cpp=_moc.o)
	$(CXX) $(CXXFLAGS) $(INCLUDES) -c $(@:.cpp=.cc) -o $(@:.cpp=.o)

.cc.o:
	$(CXX) $(CXXFLAGS) $(INCLUDES) -c -o $@ $<

define subdir_mk
    for DIR in $(1); do (cd $${DIR} && $(MAKE) $@); done
endef

