/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_DEBTORWIDGET_H_
#define _CSHOP_DEBTORWIDGET_H_

#include <qwidget.h>
#include <qlineedit.h>

#include <string>

#include "database.h"
#include "adddebtor.h"

class QTable;
class QPopupMenu;
class QAction;

class DB;

class DebtorWidget : public QWidget
{
    Q_OBJECT

  public:
    DebtorWidget(DB *db, const int deb_id, QWidget *parent = 0) throw();
    virtual ~DebtorWidget() throw() { }

  private:

    enum TableCols
    {
        IdCol,
        QuantityCol,
        CPriceCol,
        PriceCol,
        PriceSumCol
    };

    DB *_db;
    int debtor_ident;

    // ---

    DebtorInfoHatWidget *debt_head;
    QTable *table;
    QPopupMenu *table_popup;

    QAction *rasAct, *revAct;

    // ---

    void insertRow(const int row, const Debt & debt);

  private slots:
    void dataChanged(const DebtorInfoHatWidget::DataType type);
    void slot_contextMenu(int row, int col, const QPoint & pos);

    void slot_revertGoods();
    void slot_flushGoods();

  signals:
    void debtorNameChanged(const std::string &);
};

#endif  // _CSHOP_DEBTORWIDGET_H_

