/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qvalidator.h>

#include <memory>

#include "goodsdialog.h"
#include "common.h"

BuyGoodsDialog::BuyGoodsDialog(QWidget *parent, int minValue, int maxValue) : QDialog(parent)
{
    setCaption(ENCODE("Закупка товара"));

    QGridLayout *layout = new QGridLayout(this, 1, 1, 5, 0);

    QGroupBox *groupBox = new QGroupBox(this);
    layout->addWidget(groupBox, 0, 0);

    layout = new QGridLayout(groupBox, 1, 1, 5, 5);

    goodsQuantityEdit = new QSpinBox(minValue, maxValue, 1, groupBox);

    QLabel *label = new QLabel(ENCODE("Кол-во:"), groupBox);
    label->setAlignment(int(QLabel::AlignVCenter | QLabel::AlignRight));

    layout->addWidget(label, 0, 0);
    layout->addMultiCellWidget(goodsQuantityEdit, 0, 0, 1, 2);

    goodsPriceEdit = new QLineEdit(groupBox);
    goodsPriceEdit->setText("0.00");
    goodsPriceEdit->setValidator(new QDoubleValidator(this));

    label = new QLabel(ENCODE("Себе стоимость:"), groupBox);
    label->setAlignment(int(QLabel::AlignVCenter | QLabel::AlignRight));

    layout->addWidget(label, 1, 0);
    layout->addMultiCellWidget(goodsPriceEdit, 1, 1, 1, 2);

    QSpacerItem *spacer = new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Expanding);
    layout->addItem(spacer, 3, 1);

    QFrame *line = new QFrame(groupBox);
    line->setFrameShape(QFrame::HLine);
    layout->addMultiCellWidget(line, 4, 4, 0, 2);

    QWidget *buttonGroup = new QWidget(groupBox);

    QHBoxLayout *box_layout = new QHBoxLayout(buttonGroup, 0, 5);

    OkButton = new QPushButton(ENCODE("Купить"), buttonGroup);
    box_layout->addWidget(OkButton);
    connect(OkButton, SIGNAL(clicked()), this, SLOT(accept()));

    QPushButton *button = new QPushButton(ENCODE("Отмена"), buttonGroup);
    connect(button, SIGNAL(clicked()), this, SLOT(reject()));

    box_layout->addWidget(button);

    layout->addWidget(buttonGroup, 5, 2);

    adjustSize();
    clearWState(WState_Polished);
}

void BuyGoodsDialog::getData(std::string & quantity, std::string & price) const
{
    quantity = goodsQuantityEdit->text().utf8();
    price = goodsPriceEdit->text().utf8();
}

bool BuyGoodsDialog::getData(QWidget *parent, std::string & quantity, std::string & price)
{
    std::auto_ptr<BuyGoodsDialog> dialog(new BuyGoodsDialog(parent));

    if (dialog->exec() == QDialog::Accepted)
    {
        dialog->getData(quantity, price);
        return true;
    }

    return false;
}

