/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_GOODS_TABLE_H_
#define _CSHOP_GOODS_TABLE_H_

#include <qtable.h>
#include <qdialog.h>
#include <qstring.h>
#include <qspinbox.h>

#include "database.h"

class QPopupMenu;
class QAction;
class QLineEdit;
class QPushButton;
class TopWin;
class QComboBox;

class AddGoodsDialog : public QDialog
{
    Q_OBJECT

  public:
    AddGoodsDialog(QWidget *parent);
    virtual ~AddGoodsDialog() { }

    void getData(std::string & goods_id, std::string & goods_name) const;

  private:
    QSpinBox *goodsIdEdit;
    QLineEdit *goodsNameEdit;
    QPushButton *OkButton;

  private slots:
    void checkInput();
};

class PriceTableItem : public QTableItem
{ public:
    PriceTableItem(QTable *table, EditType et, const QString & text, bool wu) :
            QTableItem(table, et, text), _wu(wu) { }
    virtual ~PriceTableItem() { }

    void set_updated(const bool sup) { _wu = sup; }
    bool was_updated() const { return _wu; }

  private:
    bool _wu;
};

class DebtorSelection : public QDialog
{
    Q_OBJECT

  public:
    DebtorSelection(DB *db, const int max_value, QWidget *parent = 0);
    virtual ~DebtorSelection() { }

    int dillerIdent() const { return _DillerIdent; }
    int goodsQuantity() const { return quant_spin->value(); }

    static bool getSellDillerInfo(DB *db, const int max_value, int & ident, int & quant, QWidget *parent);

  private:
    Debtor::Container debtors;
    int _DillerIdent;

    QPushButton *okButton;
    QSpinBox *quant_spin;
    QComboBox *dillers_box;

  private slots:
    void slot_activated(int index);
    void slot_spinValueChanged(int val);
    void slot_confirm();
};

class GoodsTable : public QTable
{
    Q_OBJECT

    enum Cols
    {
        IdCol = 0,
        NameCol,
        CPriceCol,
        PercCol,
        PriceCol,
        QuantityCol
    };

  public:
    GoodsTable(QWidget *parent, DB *c_db, const int c_gg, TopWin *tw);
    virtual ~GoodsTable() { }

  private:
    DB *_db;
    const int group_id;
    TopWin *_tw;
    QPopupMenu *popupMenu;
    QAction *delGoodsAct, *sellGoodsAct, *buyGoodsAct, *giveDebtAct;
    int view_sp_col_id;

    QString storred_value;

    void insert(const int row, const Goods & goods);
    void insert(const std::string & goods_id, const std::string & goods_name);

    void updatePercent(int row);

    virtual void paintCell(QPainter *p, int row, int col, const QRect & cr, bool selected, const QColorGroup & cg);

  private slots:
    void slot_contextMenu(int row, int col, const QPoint & pos);
    void slot_showCols();
    void slot_addGoods();
    void slot_dropGoods();
    void slot_gotoRow();
    void slot_storeValue(int row, int col);
    void slot_updateValue(int row, int col);
    void slot_buyGoods();
    void slot_sellGoods();
    void slot_giveDebt();
};

#endif  // _CSHOP_GOODS_TABLE_H_

