/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_MENUWIN_H_
#define _CSHOP_MENUWIN_H_

#include <qlistview.h>
#include <qtabwidget.h>
#include <qdockwindow.h>
#include <qpoint.h>

#include "database.h"
#include "topwin.h"

class QPopupMenu;

class GoodsGroupsItem;
class GoodsGroupItem;
class DillersGroupItem;
class DillerItem;

class MenuIndexWidget : public QListView
{
    Q_OBJECT

  public:
    MenuIndexWidget(TopWin *top_win, QWidget *parent = 0);
    virtual ~MenuIndexWidget() { }

    void setDatabase(DB *db = 0);

  private slots:
    void slot_contextMenuRequested(QListViewItem *item, const QPoint & pos, int col);
    void slot_dclicked(QListViewItem *item);

    void slot_create_group();
    void slot_drop_group();
    void slot_drop_debtor();
    void slot_create_debtor();

    void slot_dillerNameChanged(const std::string & name) throw();

  private:
    DB *_db;
    TopWin *_tw;
    GoodsGroupsItem *goods_item;
    DillersGroupItem *dolg_item;

    QPopupMenu *groups_popup, *group_popup, *debtors_popup, *debtor_popup;

    GoodsGroupItem *cur_grp;
    DillerItem *cur_diller;
};

class MenuTabWidget : public QTabWidget
{ public:
    MenuTabWidget(TopWin *tw, QWidget *parent = 0);
    virtual ~MenuTabWidget() { }

    MenuIndexWidget *Index() const { return _index; }

  private:
    TopWin *_tw;
    MenuIndexWidget *_index;
};

class MenuDockWin : public QDockWindow
{ public:
    MenuDockWin(TopWin *tw, QWidget *parent = 0, Place place = InDock);
    virtual ~MenuDockWin() { }

    MenuTabWidget *Tabs() const { return _menuTabs; }

  private:
    TopWin *_tw;
    MenuTabWidget *_menuTabs;
};

class GoodsGroupsItem : public QListViewItem
{ public:
    GoodsGroupsItem(MenuIndexWidget *parent, DB *db = 0);
    virtual ~GoodsGroupsItem() { }
};

class GoodsGroupItem : public QListViewItem
{ public:
    GoodsGroupItem(GoodsGroupsItem *parent, const int c_id, const char *c_name);
    virtual ~GoodsGroupItem() { }

    int id() const { return _id; }
    const std::string & name() const { return _name; }

  private:
    int _id;
    std::string _name;
};

class DillersGroupItem : public QListViewItem
{ public:
    DillersGroupItem(QListView *parent, QListViewItem *after = 0, DB *db = 0);
    virtual ~DillersGroupItem() { }

  private:
    DB *_db;
};

class DillerItem : public QListViewItem
{ public:
    DillerItem(QListViewItem *parent, const Debtor & dbr);
    virtual ~DillerItem() { }

    int id() const { return _id; }

  private:
    int _id;
};

#endif  // _CSHOP_MENUWIN_H_

