/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#include <qtabwidget.h>
#include <qfont.h>

#include "msgwin.h"
#include "common.h"

MsgReport::MsgReport(QWidget *parent) : QListBox(parent), maxRows(100), pic()
{
    setSelectionMode(NoSelection);
}

void MsgReport::write(const char *msg)
{
    if (numRows() >= maxRows)
        removeItem(0);

    insertItem(pic, ENCODE(msg));
    setCurrentItem(numRows() - 1);
}

void MsgReport::write(const QString & msg)
{
    if (numRows() >= maxRows)
        removeItem(0);

    insertItem(pic, msg);
    setCurrentItem(numRows() - 1);
}

MsgWidget::MsgWidget(QWidget *parent) : QTabWidget(parent)
{
    setTabPosition(Bottom);

    QFont tabs_font = font();

    tabs_font.setPointSize(8);
    setFont(tabs_font);

    _msgs = new MsgReport(this);
    _sqlm = new MsgReport(this);

    insertTab(_msgs, ENCODE("Сообщения"));
    insertTab(_sqlm, ENCODE("SQL Сервер"));
}

MsgDockWin::MsgDockWin(QWidget *parent, Place place) : QDockWindow(place, parent)
{
    setCaption(ENCODE("Сообщения"));
    setOrientation(Horizontal);
    setResizeEnabled(true);
    setHorizontallyStretchable(true);
    setVerticallyStretchable(false);
    setCloseMode(Always);

    _tabs = new MsgWidget(this);

    setWidget(_tabs);
}

