/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_MSGWIN_H_
#define _CSHOP_MSGWIN_H_

#include <qlistbox.h>
#include <qpixmap.h>
#include <qtabwidget.h>
#include <qdockwindow.h>
#include <qstring.h>

#include <string>

class MsgReport : public QListBox
{ public:
    MsgReport(QWidget *parent = 0);

    void write(const char *msg);
    void write(const std::string & msg) { write(msg.c_str()); }
    void write(const QString & msg);

    bool setPicture(const char *name) { return pic.load(name); }

  private:
    int maxRows;
    QPixmap pic;
};

class MsgWidget : public QTabWidget
{ public:
    MsgWidget(QWidget *parent = 0);

    MsgReport *LogMessages() const { return _msgs; }
    MsgReport *DBMessages() const { return _sqlm; }

  private:
    MsgReport *_msgs, *_sqlm;
};

class MsgDockWin : public QDockWindow
{ public:
    MsgDockWin(QWidget *parent = 0, Place place = InDock);

    MsgWidget *Tabs() const { return _tabs; }

  private:
    MsgWidget *_tabs;
};

#endif  // _CSHOP_MSGWIN_H_

