/*
 *  Copyright (c) 2004
 *      Progressive Software Engineering Company
 */

#ifndef _CSHOP_TOPWIN_H_
#define _CSHOP_TOPWIN_H_

#include <qmainwindow.h>

#include <string>

#include "database.h"

class QAction;
class QPopupMenu;
class QDockWindow;

class ConnWin;
class MsgDockWin;
class MenuDockWin;
class QGridLayout;
class QTimer;

class TopWin : public QMainWindow
{
    Q_OBJECT

  public:
    TopWin();
    virtual ~TopWin() { }

    void setupMainWidget(QWidget *wg = 0);
    void writeSQLError(const int errno, const char *error);
    void writeMessage(const char *message);

  private slots:
    void slot_quit();
    void slot_conn();

    void slot_showMenuWin();
    void slot_showMessagesWin();

    void slot_menuFrameVisibilityChanged(bool visible);
    void slot_messagesFrameVisibilityChanged(bool visible);

    void slot_sellAccount();
    void slot_buyAccount();

    void timerDone();

    void slot_about();

  private:
    QGridLayout *cent_layout;
    QWidget *cent_lw;
    ConnWin *connWin;
    MsgDockWin *messages;
    MenuDockWin *menu;
    QPopupMenu *viewMenu, *accMenu;
    QAction *conn_action;
    QTimer *timer;

    int view_menu_id, view_messages_id;

    // --- Database ---
    DB _db;
    // ----------------

    void setFrameShown(int menu_id, QDockWindow *frame);
    void setConnectionStatus(bool connected = false, bool rep = true);

    virtual void closeEvent(QCloseEvent *e);
};

#endif  // _CSHOP_TOPWIN_H_

