dnl Checking for mysql 

AC_DEFUN([AC_LIB_MYSQL], [

dnl Checking for mysql and it's version version.
ac_have_mysql_real=0
have_mysql=yes

AC_ARG_WITH([mysql], [  --with-mysql=DIR        Where to search for mysql libraries], 
					mysql_base_dir=$with_mysql, 
					mysql_base_dir=/usr/local)
mysql_includes="$mysql_base_dir/include/mysql"
mysql_libs="$mysql_base_dir/lib/mysql"

AC_ARG_WITH([mysql-includes], [  --with-mysql-includes=DIR  Where to search for mysql includes],
					mysql_cflags="-I$with_mysql_includes", mysql_cflags=`mysql_config --cflags`)

AC_ARG_WITH([mysql-libs], [  --with-mysql-libs=DIR      Where to search for mysql libraries],
					mysql_libs="-L$with_mysql_libs -lmysqlclient", mysql_libs=`mysql_config --libs`)

ac_mysql_saved_ldflags="$LDFLAGS"
ac_mysql_saved_cflags="$CFLAGS"
ac_mysql_saved_cppflags="$CPPFLAGS"

LDFLAGS=$LDFLAGS" "`echo $mysql_libs|xargs echo`
dnl CFLAGS="$CFLAGS $mysql_cflags"
CPPFLAGS=$CPPFLAGS" "`echo $mysql_cflags|xargs echo`

AC_CHECK_HEADER(mysql.h, ac_have_mysql_h=1, ac_have_mysql_h=0)

dnl Checking for mysql and it's features.
AC_CHECK_LIB(mysqlclient, mysql_real_connect, ac_have_mysql_real=1 , ac_have_mysql_real=0)

dnl if we have no ac_have_mysql_real... functions, let's check for mysql... functions.
dnl if they does not exist, let's assume we are failed to find mysql library.
if test "$ac_have_mysql_real" -eq "0"
then
	AC_CHECK_LIB(mysqlclient, mysql_connect, ac_have_mysql_mysq=1, ac_have_mysql_lib=0)
else
	ac_have_mysql_lib=1
fi;

AC_DEFINE_UNQUOTED([HAVE_MYSQL_REAL], $ac_have_mysql_real, [Whether we have mysql_real... functions])

ac_mysql_usable=$ac_have_mysql_lib

if test "$ac_have_mysql_lib" = "1" -a "$ac_have_mysql_h" = "0"
then
	echo "configure: WARNING: libmysqlclient found, but mysql.h not."
	ac_mysql_usable=0
fi;

if test "$ac_have_mysql_lib" = "0" -a "$ac_have_mysql_h" = "1"
then
	echo "configure: WARNING: mysql.h found, but libmysqlclient not."
	ac_mysql_usable=0
fi;

AC_SUBST([MYSQL_LDFLAGS], "$mysql_libs")
AC_SUBST([MYSQL_CFLAGS], "$mysql_cflags")

LDFLAGS="$ac_mysql_saved_ldflags"
CFLAGS="$ac_mysql_saved_cflags"
CPPFLAGS="$ac_mysql_saved_cppflags"

if test "$ac_mysql_usable" = "1"
then
	$1
else
	$2
fi

])
