#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cgi/cgi.h>
#include <cgi/cookies.h>
#include <cgi/headers.h>
#include <cgi/session.h>
#include <cgi/form.h>
#include <cgi/ob_stream.h>
#include <cgi/fcgi_streams.h>
#include <cgi/utils.h>

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

extern char **environ;

struct s_cgi_context *cgi_context_create(FCGX_Request *request)
{
	struct s_cgi_context *ctx;
	
	ctx = malloc(sizeof(struct s_cgi_context));

	if(!ctx)
		return NULL;

	memset(ctx, 0, sizeof(struct s_cgi_context));

#ifdef WITH_FCGI
	if(request)
	{
		ctx->is_fcgi = 1;
		ctx->envp = request->envp;
		ctx->in = fcgi_open(request->in);
		ctx->__system_out = fcgi_open(request->out);
	}
	else
	{
		ctx->envp = environ;
		ctx->in = stdin;
		ctx->__system_out = stdout;
	}
#else
	ctx->envp = environ;
	ctx->in = stdin;
	ctx->__system_out = stdout;
#endif
	setvbuf(ctx->__system_out, NULL, _IONBF, 0);
	ctx->out = ob_open(ctx);

	ctx->headers = headers_create();
	ctx->cookies = cookies_create();
	ctx->form = form_create();

	ctx->headers->cgi_ctx = ctx;
	ctx->cookies->cgi_ctx = ctx;
	ctx->form->cgi_ctx = ctx;

	// Prepare data for usage
	form_parse_data(ctx->form);
	cookies_parse(ctx->cookies);
	header_add(ctx, "Content-type", "text/html");
	
	return ctx;
};

void cgi_context_free(struct s_cgi_context *ctx)
{
	if(!ctx)
		return;

	if(ctx->out)
		fclose(ctx->out);

	if(ctx->headers)
		headers_free(ctx->headers);

	if(ctx->cookies)
		cookies_free(ctx->cookies);

	if(ctx->form)
		form_free(ctx->form);

	if(ctx->session)
	{
		if(ctx->session->vars && ctx->session->sessid)
			session_save(ctx->session);

		session_free(ctx->session);
	}

	if(ctx->is_fcgi)
	{
		fclose(ctx->in);
		fclose(ctx->__system_out);
	}

	free(ctx);
};

char *cgi_getenv(t_cgi_context *ctx, char *name)
{
	return fast_get_env(ctx->envp, name);
};


